/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.trellis.BFTrellises;
import net.hecco.bountifulfares.trellis.TrellisUtil;
import net.hecco.bountifulfares.trellis.trellis_parts.TrellisVariant;
import net.hecco.bountifulfares.trellis.trellis_parts.VineCrop;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CropTrellisBlock
extends Block
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING;
    public static final IntegerProperty AGE;
    private final Item berryItem;
    protected static final VoxelShape NORTH_SHAPE;
    protected static final VoxelShape SOUTH_SHAPE;
    protected static final VoxelShape WEST_SHAPE;
    protected static final VoxelShape EAST_SHAPE;
    public static BooleanProperty SNIPPED;
    private final TrellisVariant variant;
    private final VineCrop crop;
    private String berryItemID;
    private final int harvestResetAge;

    public CropTrellisBlock(Item berryItem, TrellisVariant variant, VineCrop crop, BlockBehaviour.Properties settings) {
        super(settings);
        this.berryItem = berryItem;
        BFBlocks.CROPS_TO_CROP_TRELLISES.put(berryItem, this);
        this.variant = variant;
        this.crop = crop;
        this.harvestResetAge = 1;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SNIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public CropTrellisBlock(int harvestResetAge, String berryItemID, TrellisVariant variant, VineCrop crop, BlockBehaviour.Properties settings) {
        super(settings);
        this.berryItem = null;
        this.berryItemID = berryItemID;
        this.variant = variant;
        this.crop = crop;
        this.harvestResetAge = harvestResetAge;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SNIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public CropTrellisBlock(Item seedsItem, Item berryItem, TrellisVariant variant, VineCrop crop, BlockBehaviour.Properties settings) {
        super(settings);
        this.berryItem = berryItem;
        BFBlocks.CROPS_TO_CROP_TRELLISES.put(seedsItem, this);
        this.variant = variant;
        this.crop = crop;
        this.harvestResetAge = 1;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SNIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public void playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!player.isCreative()) {
            CropTrellisBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.crop.getSeedsItem()));
        }
        super.playerWillDestroy(world, pos, state, player);
    }

    public String getDescriptionId() {
        return "block." + this.variant.getModId() + "." + this.crop.getName() + "_" + this.variant.getBlockName();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, AGE, SNIPPED});
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int i = (Integer)state.getValue((Property)AGE);
        if (player.getItemInHand(hand).is(Items.SHEARS) && !((Boolean)state.getValue((Property)SNIPPED)).booleanValue()) {
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, playerx -> playerx.broadcastBreakEvent(hand));
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SNIPPED, (Comparable)Boolean.valueOf(true)));
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, playerx -> playerx.broadcastBreakEvent(hand));
            return InteractionResult.SUCCESS;
        }
        if (i != 3) {
            return InteractionResult.PASS;
        }
        if ((Integer)state.getValue((Property)AGE) == 3 & (Boolean)state.getValue((Property)SNIPPED) == false) {
            int j = 1 + world.random.nextInt(2);
            if (this.berryItem != null) {
                CropTrellisBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.berryItem, world.random.nextIntBetweenInclusive(1, 2)));
                world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
            } else if (this.berryItemID != null) {
                CropTrellisBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(this.crop.getId(), this.berryItemID)), world.random.nextIntBetweenInclusive(1, 2)));
                world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
            }
            BlockState blockState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(this.harvestResetAge));
            world.setBlock(pos, blockState, 2);
            world.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
            return InteractionResult.SUCCESS;
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)SNIPPED)).booleanValue() && !CropTrellisBlock.isFullyGrown(state) && world.random.nextFloat() < 0.2f) {
            world.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (!((Boolean)state.getValue((Property)SNIPPED)).booleanValue() && !CropTrellisBlock.isFullyGrown(state)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)TrellisUtil.getTrellisFromVariant(this.variant));
    }

    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }

    public boolean isPathfindable(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        if (CropTrellisBlock.isFullyGrown(state)) {
            return false;
        }
        return (Boolean)state.getValue((Property)SNIPPED) == false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        if (CropTrellisBlock.isFullyGrown(state)) {
            return false;
        }
        return (Boolean)state.getValue((Property)SNIPPED) == false;
    }

    protected static boolean isFullyGrown(BlockState state) {
        return (Integer)state.getValue((Property)AGE) == 3;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public static BlockState getCropTrellisFromCrop(Item seedsItem) {
        if (seedsItem != null && BFBlocks.CROPS_TO_CROP_TRELLISES.containsKey(seedsItem)) {
            return BFBlocks.CROPS_TO_CROP_TRELLISES.get(seedsItem).defaultBlockState();
        }
        return BFTrellises.TRELLISES.get("trellis").defaultBlockState();
    }

    static {
        AGE = BlockStateProperties.AGE_3;
        NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
        SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        WEST_SHAPE = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        EAST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        SNIPPED = BooleanProperty.create((String)"snipped");
        FACING = BlockStateProperties.HORIZONTAL_FACING;
    }
}

