/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import java.util.stream.Stream;
import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.hecco.bountifulfares.block.entity.FermentationVesselBlockEntity;
import net.hecco.bountifulfares.block.enums.FermentationStage;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.hecco.bountifulfares.util.FermentationRecipes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FermentationVesselBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<FermentationStage> FERMENTATION_STAGE = EnumProperty.create((String)"fermentation_stage", FermentationStage.class);

    public FermentationVesselBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.EMPTY))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FERMENTATION_STAGE, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue(FERMENTATION_STAGE) == FermentationStage.FERMENTING || state.getValue(FERMENTATION_STAGE) == FermentationStage.FERMENTED) {
            return Stream.of(Block.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), Block.box((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        }
        return Shapes.join((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), (VoxelShape)Block.box((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), (BooleanOp)BooleanOp.OR);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.POTION) && PotionUtils.getPotion((ItemStack)itemStack) == Potions.WATER && state.getValue(FERMENTATION_STAGE) == FermentationStage.EMPTY) {
            world.setBlock(pos, (BlockState)state.setValue(FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.WATER)), 2);
            world.playSound(null, pos, BFSounds.FERMENTATION_VESSEL_FILL, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() / 3.0f);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            if (itemStack.isEmpty() && !player.isCreative()) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            } else if (!player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE))) {
                player.drop(new ItemStack((ItemLike)Items.GLASS_BOTTLE), false);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FermentationVesselBlockEntity) {
            FermentationVesselBlockEntity entity = (FermentationVesselBlockEntity)blockEntity;
            if (FermentationRecipes.isItemInput(player, hand) && state.getValue(FERMENTATION_STAGE) == FermentationStage.WATER) {
                if (entity.canInsertItem()) {
                    Item remainder;
                    entity.insertItem(itemStack.getItem().getDefaultInstance());
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue(FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.FERMENTING)));
                    FermentationVesselBlock.pushEntitiesUp((BlockState)((BlockState)state.setValue(FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.WATER))), (BlockState)((BlockState)state.setValue(FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.FERMENTING))), (LevelAccessor)world, (BlockPos)pos);
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                    }
                    if ((remainder = FermentationRecipes.getRemainderFromInput(player.getItemInHand(hand).getItem())) != null) {
                        if (itemStack.isEmpty() && !player.isCreative()) {
                            player.setItemInHand(hand, new ItemStack((ItemLike)remainder));
                        } else if (!player.getInventory().add(new ItemStack((ItemLike)remainder))) {
                            player.drop(new ItemStack((ItemLike)remainder), false);
                        }
                    }
                    world.playSound(null, pos, BFSounds.FERMENTATION_VESSEL_SPLASH, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() / 3.0f);
                    return InteractionResult.SUCCESS;
                }
            } else if (!entity.canInsertItem()) {
                return entity.tryExtractItem(world, pos, state, player, hand);
            }
            return InteractionResult.PASS;
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        boolean bl = fluidState.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(ctx).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FermentationVesselBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return FermentationVesselBlock.createTickerHelper(type, BFBlockEntities.FERMENTATION_VESSEL_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> blockEntity.tick(world1, pos, state1));
    }
}

