/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class FruitBlock
extends FallingBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty SLICES = IntegerProperty.create((String)"slices", (int)0, (int)3);

    public FruitBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SLICES, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SLICES, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!world.getBlockState(pos.above()).is(BlockTags.LEAVES)) {
            world.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if ((Integer)state.getValue((Property)SLICES) != 3 && player.canEat(false)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)SLICES), 2);
            player.getFoodData().eat(4, 0.1f);
            world.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if ((Integer)state.getValue((Property)SLICES) == 3 && player.canEat(false)) {
            world.removeBlock(pos, false);
            player.getFoodData().eat(4, 0.1f);
            world.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!world.getBlockState(pos.above()).is(BlockTags.LEAVES)) {
            world.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        }
    }

    protected void falling(FallingBlockEntity entity) {
        if ((Integer)entity.getBlockState().getValue((Property)SLICES) != 0) {
            entity.dropItem = false;
        }
        super.falling(entity);
    }

    public void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!world.isClientSide) {
            world.destroyBlock(hit.getBlockPos(), false);
            world.playSound(null, hit.getBlockPos(), SoundEvents.BAMBOO_WOOD_FALL, SoundSource.BLOCKS, 1.0f, 1.0f);
            int stackCount = 9;
            if ((Integer)state.getValue((Property)SLICES) == 1) {
                stackCount = 4;
            } else if ((Integer)state.getValue((Property)SLICES) == 2) {
                stackCount = 2;
            } else if ((Integer)state.getValue((Property)SLICES) == 3) {
                stackCount = 1;
            }
            world.addFreshEntity((Entity)new ItemEntity(world, (double)hit.getBlockPos().getX() + 0.5, (double)hit.getBlockPos().getY() + 0.5, (double)hit.getBlockPos().getZ() + 0.5, new ItemStack((ItemLike)this.getFruitItem(), stackCount)));
        }
    }

    public Item getFruitItem() {
        return null;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (FruitBlock.isFree((BlockState)world.getBlockState(pos.below())) && pos.getY() >= world.getMinBuildHeight() && !world.getBlockState(pos.above()).is(BlockTags.LEAVES)) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)world, (BlockPos)pos, (BlockState)state);
            this.falling(fallingBlockEntity);
        }
    }
}

