/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class FruitLogBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape Y_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape Z_SHAPE = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape X_SHAPE = Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    public static final BooleanProperty LEAFY = BooleanProperty.create((String)"leafy");
    public static Block LEAVES;
    public static Block LEAVES2;

    public FruitLogBlock(Block leaves, Block floweringleaves, BlockBehaviour.Properties settings) {
        super(settings);
        LEAVES = leaves;
        LEAVES2 = floweringleaves;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)LEAFY, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)LEAFY)).booleanValue()) {
            return Shapes.block();
        }
        switch ((Direction.Axis)state.getValue((Property)AXIS)) {
            default: {
                return X_SHAPE;
            }
            case Z: {
                return Z_SHAPE;
            }
            case Y: 
        }
        return Y_SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER))).setValue((Property)LEAFY, (Comparable)Boolean.valueOf(this.shouldBeLeafy((LevelReader)ctx.getLevel(), ctx.getClickedPos(), super.defaultBlockState())));
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        boolean shouldBeLeafy;
        super.onPlace(state, world, pos, oldState, notify);
        if (!world.isClientSide && (shouldBeLeafy = this.shouldBeLeafy((LevelReader)world, pos, state)) != (Boolean)state.getValue((Property)LEAFY)) {
            world.setBlock(pos, (BlockState)state.setValue((Property)LEAFY, (Comparable)Boolean.valueOf(shouldBeLeafy)), 2);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected abstract boolean shouldBeLeafy(LevelReader var1, BlockPos var2, BlockState var3);

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (!world.isClientSide) {
            boolean shouldBeLeafy = this.shouldBeLeafy((LevelReader)world, pos, state);
            if (shouldBeLeafy && !((Boolean)state.getValue((Property)LEAFY)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)LEAFY, (Comparable)Boolean.valueOf(true)), 2);
                world.sendBlockUpdated(pos, state, state, 3);
            } else if (!shouldBeLeafy && ((Boolean)state.getValue((Property)LEAFY)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)LEAFY, (Comparable)Boolean.valueOf(false)), 2);
                world.sendBlockUpdated(pos, state, state, 3);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, AXIS, LEAFY});
    }

    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }

    public boolean isPathfindable(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

