/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.custom.FruitBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GoldenAppleBlock
extends FruitBlock {
    private static final VoxelShape[] NORTH_SHAPES = new VoxelShape[]{Shapes.join((VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] EAST_SHAPES = new VoxelShape[]{Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0)};
    private static final VoxelShape[] SOUTH_SHAPES = new VoxelShape[]{Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (BooleanOp)BooleanOp.OR), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)};
    private static final VoxelShape[] WEST_SHAPES = new VoxelShape[]{Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0)};

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)SLICES) != 0) {
            if (state.getValue((Property)FACING) == Direction.NORTH) {
                return NORTH_SHAPES[(Integer)state.getValue((Property)SLICES) - 1];
            }
            if (state.getValue((Property)FACING) == Direction.EAST) {
                return EAST_SHAPES[(Integer)state.getValue((Property)SLICES) - 1];
            }
            if (state.getValue((Property)FACING) == Direction.SOUTH) {
                return SOUTH_SHAPES[(Integer)state.getValue((Property)SLICES) - 1];
            }
            if (state.getValue((Property)FACING) == Direction.WEST) {
                return WEST_SHAPES[(Integer)state.getValue((Property)SLICES) - 1];
            }
        }
        return super.getShape(state, world, pos, context);
    }

    public GoldenAppleBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if ((Integer)state.getValue((Property)SLICES) != 3 && player.canEat(true)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)SLICES), 2);
            if (player.canEat(false)) {
                player.getFoodData().eat(4, 0.1f);
            }
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
            player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 2400, 0));
            world.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if ((Integer)state.getValue((Property)SLICES) == 3 && player.canEat(true)) {
            world.removeBlock(pos, false);
            if (player.canEat(false)) {
                player.getFoodData().eat(4, 0.1f);
            }
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
            player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 2400, 0));
            world.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public Item getFruitItem() {
        return Items.GOLDEN_APPLE;
    }
}

