/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.BountifulFares;
import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.custom.HangingFruitBlock;
import net.hecco.bountifulfares.item.BFItems;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingPlumBlock
extends HangingFruitBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)7.0, (double)14.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.box((double)6.5, (double)13.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), Shapes.join((VoxelShape)Block.box((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), (VoxelShape)Block.box((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)5.5, (double)10.0, (double)5.5, (double)10.5, (double)15.0, (double)10.5), (VoxelShape)Block.box((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.OR)};
    private static final VoxelShape[] COLL_SHAPES = new VoxelShape[]{Shapes.empty(), Shapes.empty(), Block.box((double)6.5, (double)13.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), Shapes.join((VoxelShape)Block.box((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), (VoxelShape)Block.box((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)5.5, (double)10.0, (double)5.5, (double)10.5, (double)15.0, (double)10.5), (VoxelShape)Block.box((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.OR)};

    public HangingPlumBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape = SHAPES[(Integer)state.getValue((Property)AGE)];
        if (!BountifulFares.isModLoaded("twigs") && !BountifulFares.isModLoaded("etcetera")) {
            Vec3 vec3d = state.getOffset(world, pos);
            return voxelShape.move(vec3d.x, vec3d.y, vec3d.z);
        }
        return voxelShape;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape = COLL_SHAPES[(Integer)state.getValue((Property)AGE)];
        if (!BountifulFares.isModLoaded("twigs") && !BountifulFares.isModLoaded("etcetera")) {
            Vec3 vec3d = state.getOffset(world, pos);
            return voxelShape.move(vec3d.x, vec3d.y, vec3d.z);
        }
        return voxelShape;
    }

    public float getMaxHorizontalOffset() {
        if (BountifulFares.isModLoaded("twigs") || BountifulFares.isModLoaded("etcetera")) {
            return 0.0f;
        }
        return super.getMaxHorizontalOffset();
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN) && !world.isWaterAt(pos) || world.getBlockState(pos.above()).is(BFBlocks.PLUM_LEAVES) && !world.isWaterAt(pos) || world.getBlockState(pos.above()).is(BFBlocks.FLOWERING_PLUM_LEAVES) && !world.isWaterAt(pos);
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i != 4 && player.getItemInHand(hand).is(Items.BONE_MEAL)) {
            return InteractionResult.PASS;
        }
        if (i == 4) {
            HangingFruitBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFItems.PLUM, 1));
            world.playSound(null, pos, BFSounds.HANGING_FRUIT_PICK, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
            if (!world.isClientSide()) {
                if (BountifulFares.CONFIG.isFruitReplaceWhenPicked()) {
                    BlockState blockState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0));
                    world.setBlock(pos, blockState, 2);
                    world.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
                } else {
                    world.removeBlock(pos, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BFItems.PLUM);
    }
}

