/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PicketsBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)8.0, (double)16.0);
    public static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)2.0);
    public static final VoxelShape WEST_SHAPE = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape NORTH_COLL = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)10.0, (double)16.0);
    public static final VoxelShape EAST_COLL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)10.0, (double)16.0);
    public static final VoxelShape SOUTH_COLL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0);
    public static final VoxelShape WEST_COLL = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public PicketsBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        ArrayList<VoxelShape> SHAPES = new ArrayList<VoxelShape>();
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            SHAPES.add(NORTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            SHAPES.add(EAST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            SHAPES.add(SOUTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            SHAPES.add(WEST_SHAPE);
        }
        if (!SHAPES.isEmpty()) {
            VoxelShape result = (VoxelShape)SHAPES.get(0);
            for (int i = 1; i < SHAPES.size(); ++i) {
                result = Shapes.or((VoxelShape)result, (VoxelShape)((VoxelShape)SHAPES.get(i)));
            }
            return result;
        }
        return super.getShape(state, world, pos, context);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        ArrayList<VoxelShape> COLLISION = new ArrayList<VoxelShape>();
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            COLLISION.add(NORTH_COLL);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            COLLISION.add(EAST_COLL);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            COLLISION.add(SOUTH_COLL);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            COLLISION.add(WEST_COLL);
        }
        if (!COLLISION.isEmpty()) {
            VoxelShape result = (VoxelShape)COLLISION.get(0);
            for (int i = 1; i < COLLISION.size(); ++i) {
                result = Shapes.or((VoxelShape)result, (VoxelShape)((VoxelShape)COLLISION.get(i)));
            }
            return result;
        }
        return super.getCollisionShape(state, world, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction playerDir = ctx.getHorizontalDirection().getOpposite();
        BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos());
        if (blockState.is((Block)this)) {
            Direction facingDirection = this.getFacingDirection(blockState);
            if (facingDirection != playerDir) {
                return (BlockState)super.withPropertiesOf(blockState).setValue(this.getFacingProperty(playerDir), (Comparable)Boolean.valueOf(true));
            }
        } else {
            return (BlockState)((BlockState)super.defaultBlockState().setValue(this.getFacingProperty(playerDir), (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
        }
        return (BlockState)super.getStateForPlacement(ctx).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        if (context.getPlayer() != null) {
            Direction playerDir = context.getHorizontalDirection().getOpposite();
            Direction facingDirection = this.getFacingDirection(state);
            return !context.isSecondaryUseActive() && context.getItemInHand().getItem() == this.asItem() && facingDirection != playerDir || super.canBeReplaced(state, context);
        }
        return true;
    }

    private Direction getFacingDirection(BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)NORTH)).booleanValue()) {
            return Direction.NORTH;
        }
        if (((Boolean)blockState.getValue((Property)EAST)).booleanValue()) {
            return Direction.EAST;
        }
        if (((Boolean)blockState.getValue((Property)SOUTH)).booleanValue()) {
            return Direction.SOUTH;
        }
        if (((Boolean)blockState.getValue((Property)WEST)).booleanValue()) {
            return Direction.WEST;
        }
        return Direction.NORTH;
    }

    private Property<Boolean> getFacingProperty(Direction direction) {
        switch (direction) {
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            default -> super.mirror(state, mirror);
        };
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }

    public boolean isPathfindable(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

