/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.custom.FruitLogBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PlumLogBlock
extends FruitLogBlock {
    public PlumLogBlock(Block leaves, Block floweringleaves, BlockBehaviour.Properties settings) {
        super(leaves, floweringleaves, settings);
    }

    @Override
    protected boolean shouldBeLeafy(LevelReader world, BlockPos pos, BlockState blockState) {
        Direction.Axis axis = (Direction.Axis)blockState.getValue((Property)AXIS);
        Direction[] directions = axis == Direction.Axis.X ? new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH} : (axis == Direction.Axis.Z ? new Direction[]{Direction.UP, Direction.DOWN, Direction.WEST, Direction.EAST} : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});
        for (Direction direction : directions) {
            BlockState neighborState = world.getBlockState(pos.relative(direction));
            if (neighborState.getBlock() == BFBlocks.PLUM_LEAVES || neighborState.getBlock() == BFBlocks.FLOWERING_PLUM_LEAVES) continue;
            return false;
        }
        return true;
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (!world.isClientSide) {
            boolean shouldBeLeafy = this.shouldBeLeafy((LevelReader)world, pos, state);
            if (shouldBeLeafy && !((Boolean)state.getValue((Property)LEAFY)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)LEAFY, (Comparable)Boolean.valueOf(true)), 2);
                world.sendBlockUpdated(pos, state, state, 3);
            } else if (!shouldBeLeafy && ((Boolean)state.getValue((Property)LEAFY)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)LEAFY, (Comparable)Boolean.valueOf(false)), 2);
                world.sendBlockUpdated(pos, state, state, 3);
            }
        }
    }
}

