/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScorchkinStemBlock
extends BushBlock
implements BonemealableBlock {
    public static BooleanProperty ATTACHED = BooleanProperty.create((String)"attached");
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)};
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)3);

    public ScorchkinStemBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)AGE) == 3 && ((Boolean)state.getValue((Property)ATTACHED)).equals(true)) {
            return SHAPES[4];
        }
        return SHAPES[(Integer)state.getValue((Property)AGE)];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, ATTACHED});
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextFloat() < 0.1f && this.checkForLava(world, pos)) {
            BlockPos SCORCHKINPos;
            if (!ScorchkinStemBlock.isFullyGrown(state) && !((Boolean)state.getValue((Property)ATTACHED)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
            }
            if (ScorchkinStemBlock.isFullyGrown(state) && !((Boolean)state.getValue((Property)ATTACHED)).booleanValue() && (world.getBlockState(SCORCHKINPos = pos.relative(Direction.DOWN)).isAir() || world.getBlockState(SCORCHKINPos).is(Blocks.LAVA) && ScorchkinStemBlock.isFullyGrown(state))) {
                world.setBlock(SCORCHKINPos, BFBlocks.SCORCHKIN.defaultBlockState(), 2);
                world.setBlockAndUpdate(pos, (BlockState)this.withPropertiesOf(state).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public boolean checkForLava(ServerLevel world, BlockPos pos) {
        BlockPos iPos = pos.below();
        while (!world.getBlockState(iPos).getFluidState().is(FluidTags.LAVA)) {
            if (world.getBlockState(iPos).isRedstoneConductor((BlockGetter)world, pos)) {
                return false;
            }
            iPos = iPos.below();
        }
        return true;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return !ScorchkinStemBlock.isFullyGrown(state);
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return !ScorchkinStemBlock.isFullyGrown(state);
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (!ScorchkinStemBlock.isFullyGrown(state) && !((Boolean)state.getValue((Property)ATTACHED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
    }

    public boolean shouldPropagatePrismarine(ServerLevel world, BlockPos pos) {
        return world.getBlockState(pos.below()).is(Blocks.SEA_LANTERN);
    }

    protected static boolean isFullyGrown(BlockState state) {
        return (Integer)state.getValue((Property)AGE) == 3;
    }

    protected boolean canPlantOnTop(BlockGetter world, BlockPos pos) {
        return world.getBlockState(pos.above()).isFaceSturdy(world, pos, Direction.DOWN);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.canPlantOnTop((BlockGetter)world, pos);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)ATTACHED)).booleanValue() && !world.getBlockState(pos.below()).is(BFBlocks.SCORCHKIN) && (Integer)state.getValue((Property)AGE) == 3) {
            return (BlockState)state.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false));
        }
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : state;
    }
}

