/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.custom.PrismarineBlossomBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpongekinStemBlock
extends BushBlock
implements BonemealableBlock,
LiquidBlockContainer {
    public static BooleanProperty ATTACHED = BooleanProperty.create((String)"attached");
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)};
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)3);

    public SpongekinStemBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)AGE) == 0) {
            return SHAPES[0];
        }
        if ((Integer)state.getValue((Property)AGE) == 1) {
            return SHAPES[1];
        }
        if ((Integer)state.getValue((Property)AGE) == 2) {
            return SHAPES[2];
        }
        if ((Integer)state.getValue((Property)AGE) == 3 && ((Boolean)state.getValue((Property)ATTACHED)).equals(false)) {
            return SHAPES[3];
        }
        if ((Integer)state.getValue((Property)AGE) == 3 && ((Boolean)state.getValue((Property)ATTACHED)).equals(true)) {
            return SHAPES[4];
        }
        return SHAPES[0];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, ATTACHED});
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos spongekinPos;
        if (!SpongekinStemBlock.isFullyGrown(state) && !((Boolean)state.getValue((Property)ATTACHED)).booleanValue() && random.nextFloat() < 0.1f) {
            world.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
        if (SpongekinStemBlock.isFullyGrown(state) && !((Boolean)state.getValue((Property)ATTACHED)).booleanValue() && (world.getBlockState(spongekinPos = pos.relative(Direction.UP)).isAir() || world.getBlockState(spongekinPos).is(Blocks.WATER) && SpongekinStemBlock.isFullyGrown(state))) {
            world.setBlock(spongekinPos, BFBlocks.SPONGEKIN.defaultBlockState(), 2);
            world.setBlockAndUpdate(pos, (BlockState)this.withPropertiesOf(state).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(true)));
            BlockPos prismarineBlossomPos = pos.relative(Direction.UP, 2);
            if (this.shouldPropagatePrismarine(world, pos)) {
                if (world.getBlockState(prismarineBlossomPos).is(Blocks.WATER)) {
                    world.setBlock(prismarineBlossomPos, (BlockState)BFBlocks.PRISMARINE_BLOSSOM.defaultBlockState().setValue((Property)PrismarineBlossomBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
                } else if (world.getBlockState(prismarineBlossomPos).isAir()) {
                    world.setBlock(prismarineBlossomPos, BFBlocks.PRISMARINE_BLOSSOM.defaultBlockState(), 2);
                }
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return !SpongekinStemBlock.isFullyGrown(state);
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return !SpongekinStemBlock.isFullyGrown(state);
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (!SpongekinStemBlock.isFullyGrown(state) && !((Boolean)state.getValue((Property)ATTACHED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
    }

    public boolean shouldPropagatePrismarine(ServerLevel world, BlockPos pos) {
        return world.getBlockState(pos.below()).is(Blocks.SEA_LANTERN);
    }

    protected static boolean isFullyGrown(BlockState state) {
        return (Integer)state.getValue((Property)AGE) == 3;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.isFaceSturdy(world, pos, Direction.UP) && !floor.is(Blocks.MAGMA_BLOCK);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        if (fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8) {
            return super.getStateForPlacement(ctx);
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockState blockState = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        if (!blockState.isAir()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (((Boolean)state.getValue((Property)ATTACHED)).booleanValue() && !world.getBlockState(pos.above()).is(BFBlocks.SPONGEKIN) && (Integer)state.getValue((Property)AGE) == 3) {
            return (BlockState)state.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    public FluidState getFluidState(BlockState state) {
        return Fluids.WATER.getSource(false);
    }

    public boolean canPlaceLiquid(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }
}

