/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.entity;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.hecco.bountifulfares.block.entity.ImplementedInventory;
import net.hecco.bountifulfares.networking.BFMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CeramicDishBlockEntity
extends BlockEntity
implements ImplementedInventory {
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    public int color = 0xFFFFFF;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public CeramicDishBlockEntity(BlockPos pos, BlockState state) {
        super(BFBlockEntities.CERAMIC_DISH_BLOCK_ENTITY, pos, state);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory);
        if (this.color != 0xFFFFFF) {
            nbt.putInt("color", this.color);
            super.saveAdditional(nbt);
        }
    }

    public void load(CompoundTag nbt) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory);
        super.load(nbt);
        if (nbt.getInt("color") == 0) {
            this.color = 0xFFFFFF;
        } else {
            super.saveAdditional(nbt);
            this.color = nbt.getInt("color");
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public boolean canInsertItem() {
        return this.getItem(0).isEmpty();
    }

    public void insertItem(ItemStack item) {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            this.setItem(0, item.copyWithCount(1));
            this.setChanged();
        }
    }

    public void removeItem() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            this.setItem(0, Items.AIR.getDefaultInstance());
            this.setChanged();
        }
    }

    public static int getColor(BlockGetter world, BlockPos pos) {
        if (world == null) {
            return 0xFFFFFF;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CeramicDishBlockEntity) {
            CeramicDishBlockEntity ceramicDishBlockEntity = (CeramicDishBlockEntity)blockEntity;
            return ceramicDishBlockEntity.color;
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction side) {
        return ((ItemStack)this.inventory.get(0)).isEmpty();
    }

    public void setInventory(NonNullList<ItemStack> list) {
        this.inventory.set(0, (Object)((ItemStack)list.get(0)));
    }

    public ItemStack getRenderStack() {
        return this.getItem(0);
    }

    @Override
    public void setChanged() {
        if (!this.level.isClientSide()) {
            FriendlyByteBuf data = PacketByteBufs.create();
            data.writeInt(this.inventory.size());
            for (int i = 0; i < this.inventory.size(); ++i) {
                data.writeItem((ItemStack)this.inventory.get(i));
            }
            data.writeBlockPos(this.getBlockPos());
            for (ServerPlayer player : PlayerLookup.tracking((ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos())) {
                ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)BFMessages.CERAMIC_DISH_ITEM_SYNC, (FriendlyByteBuf)data);
            }
        }
        super.setChanged();
    }
}

