/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.entity;

import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DyeableCeramicBlockEntity
extends BlockEntity {
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    public int color = 0xFFFFFF;

    public DyeableCeramicBlockEntity(BlockPos pos, BlockState state) {
        super(BFBlockEntities.CERAMIC_TILES_BLOCK_ENTITY, pos, state);
    }

    public void saveAdditional(CompoundTag nbt) {
        if (this.color != 0xFFFFFF) {
            nbt.putInt("color", this.color);
            super.saveAdditional(nbt);
        }
    }

    public void load(CompoundTag nbt) {
        if (nbt.getInt("color") == 0) {
            this.color = 0xFFFFFF;
        } else {
            super.load(nbt);
            this.color = nbt.getInt("color");
        }
    }

    public void setChanged() {
        if (this.level != null) {
            DyeableCeramicBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public static int getColor(BlockGetter world, BlockPos pos) {
        if (world == null) {
            return 0xFFFFFF;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof DyeableCeramicBlockEntity) {
            DyeableCeramicBlockEntity ceramicTilesBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
            return ceramicTilesBlockEntity.color;
        }
        return 0xFFFFFF;
    }
}

