/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.hecco.bountifulfares.block.custom.CeramicDishBlock;
import net.hecco.bountifulfares.block.entity.CeramicDishBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class CeramicDishBlockEntityRenderer
implements BlockEntityRenderer<CeramicDishBlockEntity> {
    public CeramicDishBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CeramicDishBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack itemStack = entity.getRenderStack();
        matrices.pushPose();
        matrices.translate(0.5f, 0.08f, 0.5f);
        matrices.scale(0.5f, 0.5f, 0.5f);
        matrices.mulPose(Axis.YN.rotationDegrees(((Direction)entity.getBlockState().getValue((Property)CeramicDishBlock.FACING)).toYRot() + 180.0f));
        matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
        itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, this.getLightLevel(Objects.requireNonNull(entity.getLevel()), entity.getBlockPos()), OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.getLevel(), 1);
        matrices.popPose();
    }

    private int getLightLevel(Level world, BlockPos pos) {
        int bLight = world.getBrightness(LightLayer.BLOCK, pos);
        int sLight = world.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

