/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.effect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;

public class AcidicEffect
extends MobEffect {
    private final List<MobEffectInstance> affectedEffects = new ArrayList<MobEffectInstance>();

    protected AcidicEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void addAttributeModifiers(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (!entity.getActiveEffects().isEmpty()) {
            this.affectedEffects.clear();
            ArrayList<MobEffectInstance> effectsToModify = new ArrayList<MobEffectInstance>();
            for (MobEffectInstance effect : entity.getActiveEffects()) {
                if (effect.getEffect() == this || effect.getEffect() == MobEffects.HERO_OF_THE_VILLAGE || effect.getEffect() == MobEffects.BAD_OMEN) continue;
                int newAmplifier = effect.getAmplifier() + amplifier + 1;
                if (newAmplifier > 255) {
                    newAmplifier = 255;
                }
                MobEffectInstance newEffect = new MobEffectInstance(effect.getEffect(), effect.getDuration(), newAmplifier, effect.isAmbient(), effect.isVisible(), effect.showIcon());
                effectsToModify.add(newEffect);
                this.affectedEffects.add(newEffect);
            }
            if (!effectsToModify.isEmpty()) {
                for (MobEffectInstance effect : effectsToModify) {
                    entity.removeEffect(effect.getEffect());
                    entity.addEffect(effect);
                }
            }
        }
        super.addAttributeModifiers(entity, attributes, amplifier);
    }

    public void applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.getActiveEffects().isEmpty()) {
            ArrayList<MobEffectInstance> effectsToModify = new ArrayList<MobEffectInstance>();
            for (MobEffectInstance effect : entity.getActiveEffects()) {
                boolean alreadyAffected = this.affectedEffects.stream().anyMatch(prev -> prev.getEffect() == effect.getEffect());
                if (alreadyAffected || effect.getEffect() == this || effect.getEffect() == MobEffects.HERO_OF_THE_VILLAGE || effect.getEffect() == MobEffects.BAD_OMEN) continue;
                int newAmplifier = effect.getAmplifier() + amplifier + 1;
                if (newAmplifier > 255) {
                    newAmplifier = 255;
                }
                MobEffectInstance newEffect = new MobEffectInstance(effect.getEffect(), effect.getDuration(), newAmplifier, effect.isAmbient(), effect.isVisible(), effect.showIcon());
                effectsToModify.add(newEffect);
                this.affectedEffects.add(newEffect);
            }
            if (!effectsToModify.isEmpty()) {
                effectsToModify.forEach(instance -> entity.removeEffect(instance.getEffect()));
                effectsToModify.forEach(arg_0 -> ((LivingEntity)entity).addEffect(arg_0));
            }
        }
        super.applyEffectTick(entity, amplifier);
    }

    public void removeAttributeModifiers(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (!entity.getActiveEffects().isEmpty()) {
            ArrayList<MobEffectInstance> effectsToModify = new ArrayList<MobEffectInstance>();
            Iterator<MobEffectInstance> iterator = this.affectedEffects.iterator();
            while (iterator.hasNext()) {
                MobEffectInstance effect = iterator.next();
                if (effect.getEffect() == this || !entity.hasEffect(effect.getEffect()) || effect.getEffect() == MobEffects.HERO_OF_THE_VILLAGE && effect.getEffect() == MobEffects.BAD_OMEN) continue;
                int newAmplifier = effect.getAmplifier() - amplifier - 1;
                if (newAmplifier < 0) {
                    newAmplifier = 0;
                }
                MobEffectInstance newEffect = new MobEffectInstance(effect.getEffect(), effect.getDuration(), newAmplifier, effect.isAmbient(), effect.isVisible(), effect.showIcon());
                effectsToModify.add(newEffect);
                iterator.remove();
            }
            if (!effectsToModify.isEmpty()) {
                effectsToModify.forEach(instance -> entity.removeEffect(instance.getEffect()));
                effectsToModify.forEach(arg_0 -> ((LivingEntity)entity).addEffect(arg_0));
            }
        }
        super.addAttributeModifiers(entity, attributes, amplifier);
        this.affectedEffects.clear();
    }

    public boolean isDurationEffectTick(int duration, int amplifier) {
        return true;
    }
}

