/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;

public class RestorationEffect
extends MobEffect {
    private float regenMax = 0.0f;
    private float prevRegenMax = 0.0f;

    protected RestorationEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void addAttributeModifiers(LivingEntity entity, AttributeMap attributes, int amplifier) {
        float health = entity.getHealth();
        float maxHealth = entity.getMaxHealth();
        if (health > this.regenMax && health <= maxHealth && this.prevRegenMax < health) {
            this.regenMax = health;
        }
        super.addAttributeModifiers(entity, attributes, amplifier);
    }

    public void applyEffectTick(LivingEntity entity, int amplifier) {
        float health = entity.getHealth();
        float maxHealth = entity.getMaxHealth();
        if (health < this.regenMax && health < maxHealth) {
            entity.heal(0.1f * (float)(amplifier + 1));
        }
        super.applyEffectTick(entity, amplifier);
    }

    public void removeAttributeModifiers(LivingEntity entity, AttributeMap attributes, int amplifier) {
        this.prevRegenMax = this.regenMax = 0.0f;
    }

    public boolean isDurationEffectTick(int duration, int amplifier) {
        return true;
    }
}

