/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.item.custom;

import java.util.List;
import net.hecco.bountifulfares.block.entity.CeramicDishBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class CeramicDishBlockItem
extends BlockItem
implements DyeableLeatherItem {
    public int DefColor = 0xFFFFFF;

    public CeramicDishBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public int getColor(ItemStack stack) {
        CompoundTag nbtCompound = stack.getTagElement("display");
        if (nbtCompound != null && nbtCompound.contains("color", 99)) {
            return nbtCompound.getInt("color");
        }
        return this.DefColor;
    }

    public InteractionResult place(BlockPlaceContext context) {
        InteractionResult result = super.place(context);
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof CeramicDishBlockEntity) {
            CeramicDishBlockEntity ceramicDishBlockEntity = (CeramicDishBlockEntity)blockEntity;
            ceramicDishBlockEntity.color = this.getColor(context.getItemInHand());
        }
        return result;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.translatable((String)"tooltip.bountifulfares.dyeable").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(stack, world, tooltip, context);
    }
}

