/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class MillingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public MillingRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(SimpleContainer inventory, Level world) {
        if (world.isClientSide()) {
            return false;
        }
        return ((Ingredient)this.recipeItems.get(0)).test(inventory.getItem(0));
    }

    public ItemStack craft(SimpleContainer inventory, RegistryAccess registryManager) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(RegistryAccess registryManager) {
        return this.output.copy();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public static class Serializer
    implements RecipeSerializer<MillingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final String ID = "milling";

        public MillingRecipe read(ResourceLocation id, JsonObject json) {
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"output"));
            JsonArray ingredients = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.withSize((int)1, (Object)Ingredient.EMPTY);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.fromJson((JsonElement)ingredients.get(i)));
            }
            return new MillingRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        public MillingRecipe read(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.withSize((int)buf.readInt(), (Object)Ingredient.EMPTY);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.readItem();
            return new MillingRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        public void write(FriendlyByteBuf buf, MillingRecipe recipe) {
            buf.writeInt(recipe.getIngredients().size());
            for (Ingredient ing : recipe.getIngredients()) {
                ing.toNetwork(buf);
            }
            buf.writeItem(recipe.getResultItem(null));
        }
    }

    public static class Type
    implements RecipeType<MillingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "milling";

        private Type() {
        }
    }
}

