/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.screen;

import net.hecco.bountifulfares.block.entity.GristmillBlockEntity;
import net.hecco.bountifulfares.block.entity.slot.GristmillOutputSlot;
import net.hecco.bountifulfares.screen.BFScreenHandlers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GristmillScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData propertyDelegate;
    public final GristmillBlockEntity blockEntity;
    private RecipeBookType category;

    public GristmillScreenHandler(int syncId, Inventory inventory, FriendlyByteBuf buf) {
        this(syncId, inventory, inventory.player.level().getBlockEntity(buf.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public boolean isCrafting() {
        return this.propertyDelegate.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.propertyDelegate.get(0);
        int maxProgress = this.propertyDelegate.get(1);
        int progressArrowSize = 34;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public GristmillScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity, ContainerData arrayPropertyDelegate) {
        super(BFScreenHandlers.GRISTMILL_SCREEN_HANDLER, syncId);
        GristmillScreenHandler.checkContainerSize((Container)((Container)blockEntity), (int)2);
        this.inventory = (Container)blockEntity;
        this.propertyDelegate = arrayPropertyDelegate;
        this.blockEntity = (GristmillBlockEntity)blockEntity;
        this.addSlot(new Slot(this.inventory, 0, 44, 36));
        this.addSlot(new GristmillOutputSlot(this.inventory, 1, 116, 36));
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.addDataSlots(arrayPropertyDelegate);
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot != null && slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public RecipeBookType getCategory() {
        return this.category;
    }
}

