/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.trellis;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.hecco.bountifulfares.BountifulFares;
import net.hecco.bountifulfares.datagen.BFLangProvider;
import net.hecco.bountifulfares.datagen.custom.BFTemplateModels;
import net.hecco.bountifulfares.trellis.BFTrellises;
import net.hecco.bountifulfares.trellis.trellis_parts.DecorativeVine;
import net.hecco.bountifulfares.trellis.trellis_parts.TrellisVariant;
import net.hecco.bountifulfares.trellis.trellis_parts.VineCrop;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class TrellisUtil
extends FabricTagProvider.BlockTagProvider {
    public static List<TrellisVariant> TrellisVariants = new ArrayList<TrellisVariant>();
    public static List<VineCrop> VineCrops = new ArrayList<VineCrop>(List.of(BFTrellises.PASSION_FRUIT, BFTrellises.ELDERBERRY, BFTrellises.LAPISBERRY, BFTrellises.GLOW_BERRY));
    public static List<DecorativeVine> DecorativeVines = new ArrayList<DecorativeVine>(List.of(BFTrellises.ROSE, BFTrellises.LILAC, BFTrellises.PEONY, BFTrellises.SUNFLOWER, BFTrellises.VINE, BFTrellises.WEEPING, BFTrellises.TWISTING));

    public TrellisUtil(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, registriesFuture);
    }

    public static void registerTrellisParts() {
        if (BountifulFares.isModLoaded("natures_spirit") || BountifulFares.isDatagen()) {
            DecorativeVines.add(BFTrellises.NS_LAVENDER);
            DecorativeVines.add(BFTrellises.NS_BLEEDING_HEART);
            DecorativeVines.add(BFTrellises.NS_BLUE_BULB);
            DecorativeVines.add(BFTrellises.NS_CARNATION);
            DecorativeVines.add(BFTrellises.NS_GARDENIA);
            DecorativeVines.add(BFTrellises.NS_MARIGOLD);
            DecorativeVines.add(BFTrellises.NS_FOXGLOVE);
        }
        if (BountifulFares.isModLoaded("spawn") || BountifulFares.isDatagen()) {
            VineCrops.add(BFTrellises.SPAWN_SUNFLOWER);
        }
    }

    public static Block registerBlockNoItem(String id, String name, Block block) {
        return (Block)Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)new ResourceLocation(id, name), (Object)block);
    }

    public static Block registerBlock(String id, String name, Block block) {
        TrellisUtil.registerBlockItem(id, name, block);
        return (Block)Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)new ResourceLocation(id, name), (Object)block);
    }

    private static Item registerBlockItem(String id, String name, Block block) {
        return (Item)Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)new ResourceLocation(id, name), (Object)new BlockItem(block, (Item.Properties)new FabricItemSettings()));
    }

    public static Block getTrellisFromVariant(TrellisVariant variant) {
        return BFTrellises.TRELLISES.get(variant.getBlockName());
    }

    public static Block getCropTrellisFromVariant(TrellisVariant variant, VineCrop crop) {
        return BFTrellises.CROP_TRELLISES.get(crop.getName() + variant.getBlockName());
    }

    public static Block getDecorTrellisFromVariant(TrellisVariant variant, DecorativeVine vine) {
        return BFTrellises.DECORATIVE_TRELLISES.get(vine.getName() + variant.getBlockName());
    }

    public static void registerTrellisModels(BlockModelGenerators blockStateModelGenerator, TrellisVariant variant) {
        BFTemplateModels.registerTrellis(blockStateModelGenerator, variant);
        BFTemplateModels.registerCropTrellis(blockStateModelGenerator, TrellisUtil.getCropTrellisFromVariant(variant, BFTrellises.PASSION_FRUIT), variant.getBlockName(), BFTrellises.PASSION_FRUIT.getName() + "_trellis_vines", BFTrellises.PASSION_FRUIT.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerCropTrellis(blockStateModelGenerator, TrellisUtil.getCropTrellisFromVariant(variant, BFTrellises.ELDERBERRY), variant.getBlockName(), BFTrellises.ELDERBERRY.getName() + "_trellis_vines", BFTrellises.ELDERBERRY.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerCropTrellis(blockStateModelGenerator, TrellisUtil.getCropTrellisFromVariant(variant, BFTrellises.LAPISBERRY), variant.getBlockName(), BFTrellises.LAPISBERRY.getName() + "_trellis_vines", BFTrellises.LAPISBERRY.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerCropTrellis(blockStateModelGenerator, TrellisUtil.getCropTrellisFromVariant(variant, BFTrellises.GLOW_BERRY), variant.getBlockName(), BFTrellises.GLOW_BERRY.getName() + "_trellis_vines", BFTrellises.GLOW_BERRY.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.ROSE), variant.getBlockName(), BFTrellises.ROSE.getName() + "_trellis_vines", BFTrellises.ROSE.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.LILAC), variant.getBlockName(), BFTrellises.LILAC.getName() + "_trellis_vines", BFTrellises.LILAC.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.PEONY), variant.getBlockName(), BFTrellises.PEONY.getName() + "_trellis_vines", BFTrellises.PEONY.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.SUNFLOWER), variant.getBlockName(), BFTrellises.SUNFLOWER.getName() + "_trellis_vines", BFTrellises.SUNFLOWER.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.VINE), variant.getBlockName(), BFTrellises.VINE.getName() + "_trellis_vines", BFTrellises.VINE.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.WEEPING), variant.getBlockName(), BFTrellises.WEEPING.getName() + "_trellis_vines", BFTrellises.WEEPING.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerUpsideDownDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.TWISTING), variant.getBlockName(), BFTrellises.TWISTING.getName() + "_trellis_vines", BFTrellises.TWISTING.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_LAVENDER), variant.getBlockName(), BFTrellises.NS_LAVENDER.getName() + "_trellis_vines", BFTrellises.NS_LAVENDER.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_BLEEDING_HEART), variant.getBlockName(), BFTrellises.NS_BLEEDING_HEART.getName() + "_trellis_vines", BFTrellises.NS_BLEEDING_HEART.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_BLUE_BULB), variant.getBlockName(), BFTrellises.NS_BLUE_BULB.getName() + "_trellis_vines", BFTrellises.NS_BLUE_BULB.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_CARNATION), variant.getBlockName(), BFTrellises.NS_CARNATION.getName() + "_trellis_vines", BFTrellises.NS_CARNATION.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_GARDENIA), variant.getBlockName(), BFTrellises.NS_GARDENIA.getName() + "_trellis_vines", BFTrellises.NS_GARDENIA.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_MARIGOLD), variant.getBlockName(), BFTrellises.NS_MARIGOLD.getName() + "_trellis_vines", BFTrellises.NS_MARIGOLD.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerDecorTrellis(blockStateModelGenerator, TrellisUtil.getDecorTrellisFromVariant(variant, BFTrellises.NS_FOXGLOVE), variant.getBlockName(), BFTrellises.NS_FOXGLOVE.getName() + "_trellis_vines", BFTrellises.NS_FOXGLOVE.getName() + "_trellis_foliage", variant.getModId());
        BFTemplateModels.registerCropTrellis(blockStateModelGenerator, TrellisUtil.getCropTrellisFromVariant(variant, BFTrellises.SPAWN_SUNFLOWER), variant.getBlockName(), BFTrellises.SPAWN_SUNFLOWER.getName() + "_trellis_vines", BFTrellises.SPAWN_SUNFLOWER.getName() + "_trellis_foliage", variant.getModId());
    }

    public static void registerTrellisTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, TrellisVariant trellis) {
        String temp = BFLangProvider.capitalizeString(BuiltInRegistries.ITEM.getKey((Object)TrellisUtil.getTrellisFromVariant(trellis).asItem()).getPath().replace("_", " "));
        translationBuilder.add(TrellisUtil.getTrellisFromVariant(trellis), temp);
        for (VineCrop crop : VineCrops) {
            translationBuilder.add(TrellisUtil.getCropTrellisFromVariant(trellis, crop), temp);
        }
        for (DecorativeVine vine : DecorativeVines) {
            translationBuilder.add(TrellisUtil.getDecorTrellisFromVariant(trellis, vine), temp);
        }
    }

    public static void registerTrellisTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, TrellisVariant trellis, String display) {
        translationBuilder.add(TrellisUtil.getTrellisFromVariant(trellis), display);
        for (VineCrop crop : VineCrops) {
            translationBuilder.add(TrellisUtil.getCropTrellisFromVariant(trellis, crop), display);
        }
        for (DecorativeVine vine : DecorativeVines) {
            translationBuilder.add(TrellisUtil.getDecorTrellisFromVariant(trellis, vine), display);
        }
    }

    public static void registerTrellisRecipe(Consumer<FinishedRecipe> exporter, TrellisVariant trellis) {
        if (trellis.getCraftingItem() != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)TrellisUtil.getTrellisFromVariant(trellis)).pattern("# #").pattern(" P ").pattern("# #").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('P'), (ItemLike)trellis.getCraftingItem()).unlockedBy("has_stick", (CriterionTriggerInstance)RecipeProvider.has((ItemLike)Items.STICK)).unlockedBy("has_planks", (CriterionTriggerInstance)RecipeProvider.has((ItemLike)trellis.getCraftingItem())).group("trellis").save(exporter);
        }
    }

    protected void method_10514(HolderLookup.Provider arg) {
    }
}

