/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.util;

import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.hecco.bountifulfares.BountifulFares;
import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.entity.FlourProjectileEntity;
import net.hecco.bountifulfares.item.BFItems;
import net.hecco.bountifulfares.mixin.BrewingRecipeRegistryMixin;
import net.hecco.bountifulfares.potion.BFPotions;
import net.hecco.bountifulfares.trellis.TrellisUtil;
import net.hecco.bountifulfares.trellis.trellis_parts.TrellisVariant;
import net.hecco.bountifulfares.util.BFItemTags;
import net.hecco.bountifulfares.util.FermentationRecipes;
import net.hecco.bountifulfares.util.FlourDispenserBehavior;
import net.hecco.bountifulfares.util.GrassSeedsDispenserBehavior;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;

public class BFRegistries {
    public static void RegisterModStuffs() {
        BFRegistries.registerStrippables();
        BFRegistries.registerCeramicCheckeredConversions();
        BFRegistries.registerFuels();
        BFRegistries.registerModCompostables();
        BFRegistries.registerPotionRecipes();
        BFRegistries.registerFermentationRecipes();
        DispenserBlock.registerBehavior((ItemLike)BFItems.FLOUR, (DispenseItemBehavior)new FlourDispenserBehavior(){

            @Override
            protected Projectile createProjectile(Level world, Position position, ItemStack stack) {
                return new FlourProjectileEntity(world, position.x(), position.y(), position.z());
            }
        });
        DispenserBlock.registerBehavior((ItemLike)BFItems.GRASS_SEEDS, (DispenseItemBehavior)new GrassSeedsDispenserBehavior(){

            @Override
            public ItemStack execute(BlockSource pointer, ItemStack stack) {
                return super.execute(pointer, stack);
            }
        });
    }

    public static void registerFermentationRecipes() {
        FermentationRecipes.addRecipe(BFItems.ELDERBERRIES, null, BFItems.ELDERBERRY_WINE_BOTTLE, Items.GLASS_BOTTLE, null);
        FermentationRecipes.addRecipe(BFItems.LAPISBERRIES, null, BFItems.LAPISBERRY_WINE_BOTTLE, Items.GLASS_BOTTLE, null);
        FermentationRecipes.addRecipe(Items.HONEY_BOTTLE, Items.GLASS_BOTTLE, BFItems.MEAD_BOTTLE, Items.GLASS_BOTTLE, null);
        FermentationRecipes.addRecipe(Items.APPLE, null, BFItems.APPLE_CIDER_JAR, BFItems.JAR, null);
        FermentationRecipes.addRecipe(BFItems.PLUM, null, BFItems.PLUM_CIDER_JAR, BFItems.JAR, null);
        FermentationRecipes.addRecipe(BFItems.HOARY_APPLE, null, BFItems.HOARY_CIDER_JAR, BFItems.JAR, null);
        FermentationRecipes.addRecipe(BFItems.ORANGE, null, BFItems.CITRUS_ESSENCE, null, 4);
        FermentationRecipes.addRecipe(BFItems.LEMON, null, BFItems.CITRUS_ESSENCE, null, 4);
        FermentationRecipes.addRecipe(Items.SPIDER_EYE, null, Items.FERMENTED_SPIDER_EYE, null, null);
    }

    public static void registerFuels() {
        FuelRegistry registry = FuelRegistry.INSTANCE;
        registry.add(BFItemTags.FRUIT_LOGS, (Object)200);
        registry.add(BFItemTags.HOARY_LOGS, (Object)300);
        registry.add(BFItemTags.WALNUT_LOGS, (Object)300);
        registry.add(BFItemTags.PICKETS, (Object)200);
        for (TrellisVariant trellis : TrellisUtil.TrellisVariants) {
            registry.add((ItemLike)TrellisUtil.getTrellisFromVariant(trellis), (Object)300);
        }
        registry.add((ItemLike)BFBlocks.GRISTMILL, (Object)300);
        registry.add((ItemLike)BFBlocks.WHITE_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.LIGHT_GRAY_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.GRAY_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.BLACK_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.BROWN_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.RED_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.ORANGE_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.YELLOW_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.LIME_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.GREEN_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.CYAN_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.LIGHT_BLUE_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.BLUE_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.PURPLE_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.MAGENTA_JACK_O_STRAW, (Object)400);
        registry.add((ItemLike)BFBlocks.PINK_JACK_O_STRAW, (Object)400);
        if (BountifulFares.isModLoaded("mint")) {
            registry.add((ItemLike)BFBlocks.ACORN_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.AMBER_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.ARTICHOKE_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.BANANA_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.CERULEAN_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.FUCHSIA_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.GRAPE_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.INDIGO_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.MAROON_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.MAUVE_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.MINT_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.MOLD_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.NAVY_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.PEACH_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.PERIWINKLE_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.SAGE_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.SAP_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.SHAMROCK_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.VELVET_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.VERMILION_JACK_O_STRAW, (Object)400);
        }
        if (BountifulFares.isModLoaded("dye_depot")) {
            registry.add((ItemLike)BFBlocks.MAROON_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.ROSE_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.CORAL_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.GINGER_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.TAN_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.BEIGE_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.AMBER_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.OLIVE_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.FOREST_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.VERDANT_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.TEAL_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.MINT_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.AQUA_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.SLATE_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.NAVY_JACK_O_STRAW, (Object)400);
            registry.add((ItemLike)BFBlocks.INDIGO_JACK_O_STRAW, (Object)400);
        }
        if (BountifulFares.isModLoaded("excessive_building")) {
            registry.add((ItemLike)BFBlocks.WALNUT_VERTICAL_STAIRS, (Object)300);
            registry.add((ItemLike)BFBlocks.CHISELED_WALNUT_PLANKS, (Object)300);
            registry.add((ItemLike)BFBlocks.WALNUT_MOSAIC, (Object)300);
            registry.add((ItemLike)BFBlocks.WALNUT_MOSAIC_SLAB, (Object)300);
            registry.add((ItemLike)BFBlocks.WALNUT_MOSAIC_STAIRS, (Object)300);
            registry.add((ItemLike)BFBlocks.WALNUT_MOSAIC_VERTICAL_STAIRS, (Object)300);
            registry.add((ItemLike)BFBlocks.WALNUT_LADDER, (Object)300);
            registry.add((ItemLike)BFBlocks.HOARY_VERTICAL_STAIRS, (Object)300);
            registry.add((ItemLike)BFBlocks.CHISELED_HOARY_PLANKS, (Object)300);
            registry.add((ItemLike)BFBlocks.HOARY_MOSAIC, (Object)300);
            registry.add((ItemLike)BFBlocks.HOARY_MOSAIC_SLAB, (Object)300);
            registry.add((ItemLike)BFBlocks.HOARY_MOSAIC_STAIRS, (Object)300);
            registry.add((ItemLike)BFBlocks.HOARY_MOSAIC_VERTICAL_STAIRS, (Object)300);
            registry.add((ItemLike)BFBlocks.HOARY_LADDER, (Object)300);
        }
    }

    public static void registerCeramicCheckeredConversions() {
        BFRegistries.registerCheckeredCeramic(BFBlocks.CERAMIC_TILES, BFBlocks.CHECKERED_CERAMIC_TILES);
        BFRegistries.registerCheckeredCeramic(BFBlocks.CERAMIC_TILE_STAIRS, BFBlocks.CHECKERED_CERAMIC_TILE_STAIRS);
        BFRegistries.registerCheckeredCeramic(BFBlocks.CERAMIC_TILE_SLAB, BFBlocks.CHECKERED_CERAMIC_TILE_SLAB);
        BFRegistries.registerCheckeredCeramic(BFBlocks.CRACKED_CERAMIC_TILES, BFBlocks.CRACKED_CHECKERED_CERAMIC_TILES);
        BFRegistries.registerCheckeredCeramic(BFBlocks.CERAMIC_MOSAIC, BFBlocks.CHECKERED_CERAMIC_MOSAIC);
        BFRegistries.registerCheckeredCeramic(BFBlocks.CERAMIC_MOSAIC_STAIRS, BFBlocks.CHECKERED_CERAMIC_MOSAIC_STAIRS);
        BFRegistries.registerCheckeredCeramic(BFBlocks.CERAMIC_MOSAIC_SLAB, BFBlocks.CHECKERED_CERAMIC_MOSAIC_SLAB);
        if (BountifulFares.isModLoaded("excessive_building")) {
            BFRegistries.registerCheckeredCeramic(BFBlocks.CERAMIC_TILE_VERTICAL_STAIRS, BFBlocks.CHECKERED_CERAMIC_TILE_VERTICAL_STAIRS);
            BFRegistries.registerCheckeredCeramic(BFBlocks.CERAMIC_MOSAIC_VERTICAL_STAIRS, BFBlocks.CHECKERED_CERAMIC_MOSAIC_VERTICAL_STAIRS);
        }
    }

    public static void registerCheckeredCeramic(Block normal, Block checkered) {
        BFBlocks.CERAMIC_TO_CHECKERED_CERAMIC.put(normal, checkered);
        BFBlocks.CERAMIC_TO_CHECKERED_CERAMIC.put(checkered, normal);
    }

    public static void registerStrippables() {
        StrippableBlockRegistry.register((Block)BFBlocks.APPLE_LOG, (Block)BFBlocks.STRIPPED_APPLE_LOG);
        StrippableBlockRegistry.register((Block)BFBlocks.APPLE_WOOD, (Block)BFBlocks.STRIPPED_APPLE_WOOD);
        StrippableBlockRegistry.register((Block)BFBlocks.ORANGE_LOG, (Block)BFBlocks.STRIPPED_ORANGE_LOG);
        StrippableBlockRegistry.register((Block)BFBlocks.ORANGE_WOOD, (Block)BFBlocks.STRIPPED_ORANGE_WOOD);
        StrippableBlockRegistry.register((Block)BFBlocks.LEMON_LOG, (Block)BFBlocks.STRIPPED_LEMON_LOG);
        StrippableBlockRegistry.register((Block)BFBlocks.LEMON_WOOD, (Block)BFBlocks.STRIPPED_LEMON_WOOD);
        StrippableBlockRegistry.register((Block)BFBlocks.PLUM_LOG, (Block)BFBlocks.STRIPPED_PLUM_LOG);
        StrippableBlockRegistry.register((Block)BFBlocks.PLUM_WOOD, (Block)BFBlocks.STRIPPED_PLUM_WOOD);
        StrippableBlockRegistry.register((Block)BFBlocks.HOARY_LOG, (Block)BFBlocks.STRIPPED_HOARY_LOG);
        StrippableBlockRegistry.register((Block)BFBlocks.HOARY_WOOD, (Block)BFBlocks.STRIPPED_HOARY_WOOD);
        StrippableBlockRegistry.register((Block)BFBlocks.WALNUT_LOG, (Block)BFBlocks.STRIPPED_WALNUT_LOG);
        StrippableBlockRegistry.register((Block)BFBlocks.WALNUT_WOOD, (Block)BFBlocks.STRIPPED_WALNUT_WOOD);
    }

    private static void registerModCompostables() {
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.APPLE_LEAVES.asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.FLOWERING_APPLE_LEAVES.asItem(), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.APPLE_SAPLING.asItem(), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.APPLE_BLOCK.asItem(), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.ORANGE_LEAVES.asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.FLOWERING_ORANGE_LEAVES.asItem(), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.ORANGE_SAPLING.asItem(), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.ORANGE_BLOCK.asItem(), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.ORANGE, 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.LEMON_LEAVES.asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.FLOWERING_LEMON_LEAVES.asItem(), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.LEMON_SAPLING.asItem(), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.LEMON_BLOCK.asItem(), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.LEMON, 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.PLUM_LEAVES.asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.FLOWERING_PLUM_LEAVES.asItem(), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.PLUM_SAPLING.asItem(), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.PLUM_BLOCK.asItem(), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.PLUM, 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.HOARY_SEEDS, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.HOARY_LEAVES.asItem(), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.HOARY_APPLE_SAPLING.asItem(), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.HOARY_APPLE_BLOCK.asItem(), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.HOARY_APPLE, 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.WALNUT_LEAVES.asItem(), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.WALNUT_SAPLING.asItem(), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.WALNUT, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.WALNUT_MULCH.asItem(), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.WALNUT_MULCH_BLOCK.asItem(), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.PASSION_FRUIT, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.ELDERBERRIES, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.LAPISBERRY_SEEDS, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.LAPISBERRIES, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.WILD_WHEAT, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.WILD_POTATOES, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.WILD_CARROTS, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.WILD_BEETROOTS, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.WILD_MAIZE, 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.WILD_LEEKS, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.GRASS_SEEDS, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.MAIZE_SEEDS, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.MAIZE, 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.LEEK_SEEDS, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.LEEK, 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.FLOUR, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.SPONGEKIN_SEEDS, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.SPONGEKIN.asItem(), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.SPONGEKIN_SLICE, 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.TEA_BERRIES, 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.TEA_LEAVES, 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.DRIED_TEA_LEAVES, 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.CHAMOMILE_FLOWERS.asItem(), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.HONEYSUCKLE.asItem(), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFBlocks.VIOLET_BELLFLOWER.asItem(), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.GREEN_TEA_BLEND, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.BLACK_TEA_BLEND, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.CHAMOMILE_TEA_BLEND, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.HONEYSUCKLE_TEA_BLEND, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.BELLFLOWER_TEA_BLEND, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.TORCHFLOWER_TEA_BLEND, 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.MAIZE_BREAD, 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)BFItems.WALNUT_COOKIE, 0.85f);
    }

    private static void registerPotionRecipes() {
        BrewingRecipeRegistryMixin.invokeRegisterPotionRecipe(Potions.AWKWARD, BFItems.CITRUS_ESSENCE, BFPotions.ACIDIC);
        BrewingRecipeRegistryMixin.invokeRegisterPotionRecipe(BFPotions.ACIDIC, Items.REDSTONE, BFPotions.LONG_ACIDIC);
        BrewingRecipeRegistryMixin.invokeRegisterPotionRecipe(Potions.AWKWARD, Items.GLOWSTONE_DUST, BFPotions.STRONG_ACIDIC);
        BrewingRecipeRegistryMixin.invokeRegisterPotionRecipe(BFPotions.ACIDIC, Items.FERMENTED_SPIDER_EYE, BFPotions.STUPOR);
        BrewingRecipeRegistryMixin.invokeRegisterPotionRecipe(BFPotions.LONG_ACIDIC, Items.FERMENTED_SPIDER_EYE, BFPotions.LONG_STUPOR);
        BrewingRecipeRegistryMixin.invokeRegisterPotionRecipe(BFPotions.STUPOR, Items.REDSTONE, BFPotions.LONG_STUPOR);
    }
}

