/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.util;

import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class FlourDispenserBehavior
extends DefaultDispenseItemBehavior {
    public ItemStack execute(BlockSource pointer, ItemStack stack) {
        ServerLevel world = pointer.getLevel();
        Position position = DispenserBlock.getDispensePosition((BlockSource)pointer);
        Direction direction = (Direction)pointer.getBlockState().getValue((Property)DispenserBlock.FACING);
        Projectile projectileEntity = this.createProjectile((Level)world, position, stack);
        projectileEntity.shoot((double)direction.getStepX(), (double)((float)direction.getStepY() + 0.1f), (double)direction.getStepZ(), this.getForce(), this.getVariation());
        world.addFreshEntity((Entity)projectileEntity);
        stack.shrink(1);
        return stack;
    }

    protected void playSound(BlockSource pointer) {
        pointer.getLevel().levelEvent(1002, pointer.getPos(), 0);
    }

    protected abstract Projectile createProjectile(Level var1, Position var2, ItemStack var3);

    protected float getVariation() {
        return 10.0f;
    }

    protected float getForce() {
        return 0.5f;
    }
}

