/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.world.tree.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.world.tree.BFTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class HoaryTrunkPlacer
extends TrunkPlacer {
    public static final Codec<HoaryTrunkPlacer> CODEC = RecordCodecBuilder.create(hoaryTrunkPlacerInstance -> HoaryTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)hoaryTrunkPlacerInstance).apply((Applicative)hoaryTrunkPlacerInstance, HoaryTrunkPlacer::new));

    public HoaryTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected TrunkPlacerType<?> type() {
        return BFTrunkPlacerTypes.HOARY_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        BlockState branchState;
        BlockPos branchPos;
        int i;
        HoaryTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)startPos.below(), (TreeConfiguration)config);
        if (random.nextBoolean()) {
            BlockState branchState2;
            BlockPos branchPos2;
            int i2;
            int firstVerticalLength = random.nextIntBetweenInclusive(1, 2);
            int eastHorizontalLength = random.nextIntBetweenInclusive(2, 4);
            int westHorizontalLength = random.nextIntBetweenInclusive(3, 6);
            int bendVerticalLength = 2;
            for (i2 = 0; i2 < firstVerticalLength; ++i2) {
                this.placeLog(world, replacer, random, startPos.above(i2), config);
            }
            for (i2 = 0; i2 < eastHorizontalLength; ++i2) {
                branchPos2 = startPos.above(firstVerticalLength).relative(Direction.EAST, i2);
                branchState2 = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
                replacer.accept(branchPos2, branchState2);
            }
            for (i2 = 0; i2 < bendVerticalLength; ++i2) {
                branchPos2 = startPos.above(firstVerticalLength + i2).relative(Direction.EAST, eastHorizontalLength);
                branchState2 = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y);
                replacer.accept(branchPos2, branchState2);
            }
            for (i2 = 0; i2 < westHorizontalLength; ++i2) {
                branchPos2 = startPos.above(firstVerticalLength + bendVerticalLength).relative(Direction.EAST, eastHorizontalLength - i2);
                branchState2 = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
                replacer.accept(branchPos2, branchState2);
            }
            for (i2 = 0; i2 < bendVerticalLength; ++i2) {
                branchPos2 = startPos.above(firstVerticalLength + bendVerticalLength + i2).relative(Direction.EAST, eastHorizontalLength - westHorizontalLength);
                branchState2 = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y);
                replacer.accept(branchPos2, branchState2);
            }
            for (i2 = 0; i2 < eastHorizontalLength; ++i2) {
                branchPos2 = startPos.above(firstVerticalLength + bendVerticalLength * 2).relative(Direction.EAST, eastHorizontalLength - westHorizontalLength + i2);
                branchState2 = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
                replacer.accept(branchPos2, branchState2);
            }
            for (i2 = 0; i2 < bendVerticalLength + 1; ++i2) {
                branchPos2 = startPos.above(firstVerticalLength + bendVerticalLength * 2 + i2).relative(Direction.EAST, eastHorizontalLength - westHorizontalLength + eastHorizontalLength);
                branchState2 = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y);
                replacer.accept(branchPos2, branchState2);
            }
            return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(startPos.above(firstVerticalLength), 0, false), (Object)new FoliagePlacer.FoliageAttachment(startPos.above(firstVerticalLength + bendVerticalLength).east(eastHorizontalLength), 0, false), (Object)new FoliagePlacer.FoliageAttachment(startPos.above(firstVerticalLength + bendVerticalLength * 2).east(eastHorizontalLength - westHorizontalLength), 0, false), (Object)new FoliagePlacer.FoliageAttachment(startPos.above(firstVerticalLength + bendVerticalLength * 3).east(eastHorizontalLength - westHorizontalLength + eastHorizontalLength), 1, false));
        }
        int firstVerticalLength = random.nextIntBetweenInclusive(1, 2);
        int southHorizontalLength = random.nextIntBetweenInclusive(2, 4);
        int northHorizontalLength = random.nextIntBetweenInclusive(3, 6);
        int bendVerticalLength = 2;
        for (i = 0; i < firstVerticalLength; ++i) {
            this.placeLog(world, replacer, random, startPos.above(i), config);
        }
        for (i = 0; i < southHorizontalLength; ++i) {
            branchPos = startPos.above(firstVerticalLength).relative(Direction.SOUTH, i);
            branchState = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
            replacer.accept(branchPos, branchState);
        }
        for (i = 0; i < bendVerticalLength; ++i) {
            branchPos = startPos.above(firstVerticalLength + i).relative(Direction.SOUTH, southHorizontalLength);
            branchState = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y);
            replacer.accept(branchPos, branchState);
        }
        for (i = 0; i < northHorizontalLength; ++i) {
            branchPos = startPos.above(firstVerticalLength + bendVerticalLength).relative(Direction.SOUTH, southHorizontalLength - i);
            branchState = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
            replacer.accept(branchPos, branchState);
        }
        for (i = 0; i < bendVerticalLength; ++i) {
            branchPos = startPos.above(firstVerticalLength + bendVerticalLength + i).relative(Direction.SOUTH, southHorizontalLength - northHorizontalLength);
            branchState = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y);
            replacer.accept(branchPos, branchState);
        }
        for (i = 0; i < southHorizontalLength; ++i) {
            branchPos = startPos.above(firstVerticalLength + bendVerticalLength * 2).relative(Direction.SOUTH, southHorizontalLength - northHorizontalLength + i);
            branchState = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
            replacer.accept(branchPos, branchState);
        }
        for (i = 0; i < bendVerticalLength + 1; ++i) {
            branchPos = startPos.above(firstVerticalLength + bendVerticalLength * 2 + i).relative(Direction.SOUTH, southHorizontalLength - northHorizontalLength + southHorizontalLength);
            branchState = (BlockState)BFBlocks.HOARY_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y);
            replacer.accept(branchPos, branchState);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(startPos.above(firstVerticalLength), 0, false), (Object)new FoliagePlacer.FoliageAttachment(startPos.above(firstVerticalLength + bendVerticalLength).south(southHorizontalLength), 0, false), (Object)new FoliagePlacer.FoliageAttachment(startPos.above(firstVerticalLength + bendVerticalLength * 2).south(southHorizontalLength - northHorizontalLength), 0, false), (Object)new FoliagePlacer.FoliageAttachment(startPos.above(firstVerticalLength + bendVerticalLength * 3).south(southHorizontalLength - northHorizontalLength + southHorizontalLength), 1, false));
    }
}

