/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.world.tree.custom;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.custom.WildVineCropBlock;
import net.hecco.bountifulfares.world.tree.BFTreeDecoratorTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class PassionFruitTreeDecorator
extends TreeDecorator {
    public static final Codec<PassionFruitTreeDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(PassionFruitTreeDecorator::new, decorator -> Float.valueOf(decorator.probability)).codec();
    private final float probability;

    public PassionFruitTreeDecorator(float probability) {
        this.probability = probability;
    }

    protected TreeDecoratorType<?> type() {
        return BFTreeDecoratorTypes.PASSION_FRUIT;
    }

    public void place(TreeDecorator.Context generator) {
        RandomSource random = generator.random();
        if (!(random.nextFloat() >= this.probability)) {
            ObjectArrayList list = generator.logs();
            int i = ((BlockPos)list.get(0)).getY();
            list.stream().filter(pos -> pos.getY() - i <= 2).forEach(pos -> {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction2;
                    BlockPos blockPos;
                    if (!(random.nextFloat() <= 1.0f) || !generator.isAir(blockPos = pos.offset((direction2 = direction.getOpposite()).getStepX(), 0, direction2.getStepZ()))) continue;
                    generator.setBlock(blockPos, (BlockState)BFBlocks.WILD_PASSION_FRUIT_VINE.defaultBlockState().setValue((Property)WildVineCropBlock.FACING, (Comparable)direction2));
                }
            });
        }
    }
}

