/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.world.tree.custom;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.world.tree.BFTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class WalnutTrunkPlacer
extends TrunkPlacer {
    public static final Codec<WalnutTrunkPlacer> CODEC = RecordCodecBuilder.create(walnutTrunkPlacerInstance -> WalnutTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)walnutTrunkPlacerInstance).apply((Applicative)walnutTrunkPlacerInstance, WalnutTrunkPlacer::new));

    public WalnutTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected TrunkPlacerType<?> type() {
        return BFTrunkPlacerTypes.WALNUT_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        BlockState stubState;
        BlockPos stubPos;
        BlockState branchState;
        BlockPos branchPos;
        int x;
        WalnutTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)startPos.below(), (TreeConfiguration)config);
        int mainHeight = random.nextIntBetweenInclusive(this.baseHeight, this.heightRandA);
        int northBranchHeight = random.nextIntBetweenInclusive(this.heightRandB, mainHeight - 1);
        int eastBranchHeight = random.nextIntBetweenInclusive(this.heightRandB, mainHeight - 1);
        int southBranchHeight = random.nextIntBetweenInclusive(this.heightRandB, mainHeight - 1);
        int westBranchHeight = random.nextIntBetweenInclusive(this.heightRandB, mainHeight - 1);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < mainHeight; ++i) {
            this.placeLog(world, replacer, random, startPos.above(i), config);
        }
        for (x = 1; x < 3; ++x) {
            branchPos = startPos.above(northBranchHeight).relative(Direction.NORTH, x);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
            replacer.accept(branchPos, branchState);
            list.add(new FoliagePlacer.FoliageAttachment(branchPos, 0, true));
        }
        for (x = 1; x < 3; ++x) {
            branchPos = startPos.above(eastBranchHeight).relative(Direction.EAST, x);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
            replacer.accept(branchPos, branchState);
            list.add(new FoliagePlacer.FoliageAttachment(branchPos, 0, false));
        }
        for (x = 1; x < 3; ++x) {
            branchPos = startPos.above(southBranchHeight).relative(Direction.SOUTH, x);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
            replacer.accept(branchPos, branchState);
            list.add(new FoliagePlacer.FoliageAttachment(branchPos, 0, false));
        }
        for (x = 1; x < 3; ++x) {
            branchPos = startPos.above(westBranchHeight).relative(Direction.WEST, x);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
            replacer.accept(branchPos, branchState);
            list.add(new FoliagePlacer.FoliageAttachment(branchPos, 0, false));
        }
        this.placeLog(world, replacer, random, startPos.above(mainHeight), config);
        int stubDirChance = random.nextIntBetweenInclusive(1, 4);
        if (stubDirChance == 1) {
            stubPos = startPos.above(random.nextIntBetweenInclusive(2, 3)).relative(Direction.NORTH, 1);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
            replacer.accept(stubPos, branchState);
        }
        if (stubDirChance == 2) {
            stubPos = startPos.above(random.nextIntBetweenInclusive(2, 3)).relative(Direction.EAST, 1);
            stubState = (BlockState)BFBlocks.WALNUT_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
            replacer.accept(stubPos, stubState);
        }
        if (stubDirChance == 3) {
            stubPos = startPos.above(random.nextIntBetweenInclusive(2, 3)).relative(Direction.SOUTH, 1);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
            replacer.accept(stubPos, branchState);
        }
        if (stubDirChance == 4) {
            stubPos = startPos.above(random.nextIntBetweenInclusive(2, 3)).relative(Direction.WEST, 1);
            stubState = (BlockState)BFBlocks.WALNUT_LOG.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
            replacer.accept(stubPos, stubState);
        }
        list.add(new FoliagePlacer.FoliageAttachment(startPos.above(mainHeight), 0, false));
        return list;
    }
}

