/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.client.gui.entity.maid.cook;

import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.client.gui.entity.maid.MaidTaskConfigGui;
import com.github.wallev.farmsoulkitchen.client.gui.widget.button.RecButton;
import com.github.wallev.farmsoulkitchen.client.gui.widget.button.ResultInfo;
import com.github.wallev.farmsoulkitchen.client.gui.widget.button.TaskInfoButton;
import com.github.wallev.farmsoulkitchen.client.gui.widget.button.TypeButton;
import com.github.wallev.farmsoulkitchen.client.gui.widget.button.Zone;
import com.github.wallev.farmsoulkitchen.config.subconfig.TaskConfig;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.inventory.container.maid.CookConfigContainer;
import com.github.wallev.farmsoulkitchen.network.NetworkHandler;
import com.github.wallev.farmsoulkitchen.network.message.ActionCookDataRecMessage;
import com.github.wallev.farmsoulkitchen.network.message.SetCookDataModeMessage;
import com.mojang.blaze3d.platform.InputConstants;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.apache.commons.lang3.StringUtils;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class CookConfigGui
extends MaidTaskConfigGui<CookConfigContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("farmsoulkitchen", "textures/gui/cook_guide.png");
    protected final Zone taskDisplay = new Zone(6, 20, 70, 20);
    protected final Zone typeDisplay = new Zone(-4, 22, 18, 18);
    protected final Zone searchBoxDisplay = new Zone(-25, 22, 18, 18);
    protected final Zone searchTextDisplay = new Zone(-25, 22, 41, 18);
    protected final Zone resultDisplay = new Zone(6, 44, 152, 86);
    protected final Zone scrollDisplay = new Zone(161, 44, 9, 86);
    protected final ResultInfo ref = new ResultInfo(4, 7, 20, 20, 2, 2);
    private final List<Recipe> recipeList = new ArrayList<Recipe>();
    private final List<RecButton> recButtons = new ArrayList<RecButton>();
    private EditBox searchBox;
    private CookData cookData;
    private ICookTask<?, ?> cookTask;

    public CookConfigGui(CookConfigContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, (Component)Component.m_237115_((String)"gui.farmsoulkitchen.cook_setting_screen.title"));
    }

    protected void initAdditionData() {
        super.initAdditionData();
        if (!(this.task instanceof ICookTask)) {
            return;
        }
        this.initCookData();
        this.initRecipeList();
    }

    private void initCookData() {
        this.cookTask = (ICookTask)this.task;
        this.cookData = (CookData)this.cookTask.getTaskData(this.maid);
    }

    private void initRecipeList() {
        List<Object> recipes;
        this.recipeList.clear();
        Level level = this.maid.f_19853_;
        RegistryAccess registryAccess = level.m_9598_();
        if (this.searchBox != null && StringUtils.isNotBlank((CharSequence)this.searchBox.m_94155_())) {
            String search = this.searchBox.m_94155_().toLowerCase(Locale.US);
            recipes = ((ICookTask)this.task).getRecipes(level).stream().filter(recipe -> ((ICookTask)this.task).getResultItem((Recipe<?>)recipe, registryAccess).m_41611_().getString().toLowerCase(Locale.US).contains(search)).toList();
        } else {
            recipes = ((ICookTask)this.task).getRecipes(level);
        }
        this.recipeList.addAll(recipes);
    }

    @Override
    protected void initAdditionWidgets() {
        super.initAdditionWidgets();
        this.addJeiButton();
        this.addTaskInfoButton();
        this.addSearchTextBox();
        this.addSearchBox();
        this.addTypeButton();
        this.addResultInfo();
        this.addScrollButton();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderAddition(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderSearchSearchText(graphics, mouseX, mouseY, partialTicks);
        this.renderSearchBox(graphics);
        this.drawSplitZoneCard(graphics);
        this.drawScrollInfoBar(graphics);
    }

    protected void m_280072_(GuiGraphics graphics, int x, int y) {
        super.m_280072_(graphics, x, y);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        super.m_7286_(pGuiGraphics, pPartialTick, pMouseX, pMouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean isCookSettingMainZone;
        boolean bl = isCookSettingMainZone = mouseX >= (double)this.visualZone.startX() && mouseY >= (double)this.visualZone.startY() && mouseX < (double)(this.visualZone.startX() + this.visualZone.width()) && mouseY < (double)(this.visualZone.startY() + this.visualZone.height());
        if (delta != 0.0 && isCookSettingMainZone) {
            if (delta > 0.0 && this.solIndex > 0) {
                --this.solIndex;
                this.m_7856_();
                return true;
            }
            if (delta < 0.0 && this.solIndex < (this.recipeList.size() - 1) / (this.ref.col() * this.ref.row())) {
                ++this.solIndex;
                this.m_7856_();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        String value = this.searchBox.m_94155_();
        this.searchBox.m_94144_(value);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.searchBox.m_94120_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.searchBox.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.searchBox);
            return true;
        }
        if (this.searchBox.m_93696_()) {
            this.searchBox.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox == null) {
            return false;
        }
        String perText = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(codePoint, modifiers)) {
            if (!Objects.equals(perText, this.searchBox.m_94155_())) {
                this.solIndex = 0;
                this.m_7856_();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean hasKeyCode = InputConstants.m_84827_((int)keyCode, (int)scanCode).m_84876_().isPresent();
        String preText = this.searchBox.m_94155_();
        if (hasKeyCode) {
            return true;
        }
        if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(preText, this.searchBox.m_94155_())) {
                this.solIndex = 0;
                this.m_7856_();
            }
            return true;
        }
        return this.searchBox.m_93696_() && this.searchBox.m_94213_() && keyCode != 256 || super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_6697_(String text, boolean overwrite) {
        if (overwrite) {
            this.searchBox.m_94144_(text);
        } else {
            this.searchBox.m_94164_(text);
        }
    }

    private void addJeiButton() {
    }

    private void addTaskInfoButton() {
        int startX = this.visualZone.startX() + this.taskDisplay.startX();
        int startY = this.visualZone.startY() + this.taskDisplay.startY();
        TaskInfoButton taskInfoButton = new TaskInfoButton(startX, startY, this.taskDisplay.width(), this.taskDisplay.height(), this.task);
        this.m_142416_((GuiEventListener)taskInfoButton);
    }

    private void addSearchTextBox() {
        final int startX = this.f_96543_ - this.f_97735_ - -this.searchTextDisplay.startX() - this.searchTextDisplay.width() - 1;
        final int startY = this.visualZone.startY() + this.searchTextDisplay.startY();
        String textCache = this.searchBox == null ? "" : this.searchBox.m_94155_();
        boolean visible = this.searchBox != null && this.searchBox.m_94213_();
        boolean focus = this.searchBox != null && this.searchBox.m_93696_();
        this.searchBox = new EditBox(this.getMinecraft().f_91062_, startX, startY, this.searchTextDisplay.width(), this.searchTextDisplay.height(), (Component)Component.m_237119_()){

            public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                if (this.m_94213_()) {
                    pGuiGraphics.m_280218_(TEXTURE, startX - CookConfigGui.this.searchBoxDisplay.width(), startY, 40, 232, 59, 18);
                    super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                }
            }

            public int m_252907_() {
                return super.m_252907_() + 5;
            }

            public int m_252754_() {
                return super.m_252754_() + 3;
            }

            public boolean m_5953_(double pMouseX, double pMouseY) {
                return this.f_93624_ && pMouseX >= (double)startX && pMouseX < (double)(startX + this.f_93618_) && pMouseY >= (double)startY && pMouseY < (double)(startY + this.f_93619_);
            }
        };
        this.searchBox.m_94194_(visible);
        this.searchBox.m_93692_(focus);
        this.searchBox.m_94144_(textCache);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(15986656);
        this.m_7787_((GuiEventListener)this.searchBox);
    }

    private void addSearchBox() {
        int startX = this.f_96543_ - this.f_97735_ - -this.searchBoxDisplay.startX() - this.searchBoxDisplay.width() - 1;
        int startY = this.visualZone.startY() + this.searchBoxDisplay.startY();
        if (this.searchBox.m_94213_()) {
            startX -= this.searchTextDisplay.width();
        }
        final int finalStartX = startX;
        StateSwitchingButton typeButton = new StateSwitchingButton(finalStartX, startY, this.searchBoxDisplay.width(), this.searchBoxDisplay.height(), this.searchBox.m_94213_()){

            public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            }

            public void m_5716_(double pMouseX, double pMouseY) {
                boolean bl = this.f_94609_ = !this.f_94609_;
                if (this.f_94609_) {
                    this.m_252865_(finalStartX - CookConfigGui.this.searchTextDisplay.width());
                    CookConfigGui.this.searchBox.m_94194_(true);
                    CookConfigGui.this.searchBox.m_93692_(true);
                    CookConfigGui.this.searchBox.m_94201_();
                    CookConfigGui.this.m_7856_();
                } else {
                    this.m_252865_(finalStartX);
                    CookConfigGui.this.searchBox.m_94194_(false);
                    CookConfigGui.this.searchBox.m_93692_(false);
                    CookConfigGui.this.searchBox.m_94144_("");
                    CookConfigGui.this.m_7856_();
                }
            }
        };
        this.m_142416_((GuiEventListener)typeButton);
    }

    private void addTypeButton() {
        int startX = this.f_96543_ - this.f_97735_ - -this.typeDisplay.startX() - this.typeDisplay.width() - 1;
        int startY = this.visualZone.startY() + this.typeDisplay.startY();
        TypeButton typeButton = new TypeButton(startX, startY, this.typeDisplay.width(), this.typeDisplay.height(), this.cookData.mode().equals(CookData.Mode.SELECT.name)){

            public void m_5716_(double mouseX, double mouseY) {
                CookConfigGui.this.setAndSyncMode(!this.isSelected);
                CookConfigGui.this.updateRecButtonsState(() -> this.toggleState());
            }
        };
        this.m_142416_((GuiEventListener)typeButton);
    }

    private void setAndSyncMode(String mode) {
        this.cookData.setMode(mode);
        NetworkHandler.sendToServer(new SetCookDataModeMessage(this.maid.m_19879_(), this.cookTask.getCookDataKey().getKey(), mode));
    }

    private void setAndSyncMode(boolean isSelected) {
        this.setAndSyncMode(isSelected ? CookData.Mode.SELECT.name : CookData.Mode.RANDOM.name);
    }

    private void addResultInfo() {
        this.recButtons.clear();
        int startX = this.visualZone.startX() + this.resultDisplay.startX();
        int startY = this.visualZone.startY() + this.resultDisplay.startY();
        int index = this.solIndex * (this.ref.row() * this.ref.col());
        for (int row = 0; row < this.ref.row(); ++row) {
            for (int col = 0; col < this.ref.col(); ++col) {
                if (index >= this.recipeList.size()) {
                    return;
                }
                Recipe recipe = this.recipeList.get(index++);
                int x = startX + (this.ref.rowWidth() + this.ref.rowSpacing()) * col;
                int y = startY + (this.ref.colHeight() + this.ref.colSpacing()) * row;
                RecButton recButton = new RecButton(this.maid, (ICookTask)this.task, this.cookData, recipe, x, y){

                    public void m_5716_(double pMouseX, double pMouseY) {
                        CookConfigGui.this.arAndSyncRec(this.getRecipe().m_6423_().toString());
                        CookConfigGui.this.updateRecButtonsState(this::toggleState);
                    }
                };
                this.initRecButtonActive(recButton);
                this.m_142416_((GuiEventListener)recButton);
                this.recButtons.add(recButton);
            }
        }
    }

    private void initRecButtonActive(RecButton recButton) {
        this.initRecButtonActive(recButton, this.cookData.mode(), this.cookData.recs());
    }

    private void initRecButtonActive(RecButton recButton, String cookTaskMode, List<String> cookTaskRecs) {
        if (!cookTaskMode.equals(CookData.Mode.SELECT.name)) {
            recButton.f_93623_ = false;
            return;
        }
        if (cookTaskRecs.size() >= (Integer)TaskConfig.COOK_SELECTED_RECIPES.get() && !cookTaskRecs.contains(recButton.getRecipe().m_6423_().toString())) {
            recButton.f_93623_ = false;
            return;
        }
        recButton.f_93623_ = true;
    }

    private void updateRecButtonsState(Runnable selfRun) {
        boolean selectedType = this.cookData.mode().equals(CookData.Mode.SELECT.name);
        List<String> cookTaskRecs1 = this.cookData.recs();
        for (RecButton recButton : this.recButtons) {
            String id = recButton.getRecipe().m_6423_().toString();
            if (!selectedType) {
                recButton.f_93623_ = false;
                continue;
            }
            if (cookTaskRecs1.size() >= (Integer)TaskConfig.COOK_SELECTED_RECIPES.get() && !cookTaskRecs1.contains(id)) {
                recButton.f_93623_ = false;
                continue;
            }
            recButton.f_93623_ = true;
        }
        selfRun.run();
    }

    private void arAndSyncRec(String rec) {
        this.cookData.addOrRemoveRec(rec);
        NetworkHandler.sendToServer(new ActionCookDataRecMessage(this.maid.m_19879_(), this.cookTask.getCookDataKey().getKey(), rec));
    }

    private void addScrollButton() {
        int startX = this.visualZone.startX() + this.scrollDisplay.startX();
        int startY = this.visualZone.startY() + this.scrollDisplay.startY();
        ImageButton upButton = new ImageButton(startX, startY, 9, 7, 199, 74, 14, TEXTURE, b -> {
            if (this.solIndex > 0) {
                --this.solIndex;
                this.m_7856_();
            }
        });
        ImageButton downButton = new ImageButton(startX, startY + 8 + 1 + 70, 9, 7, 208, 74, 14, TEXTURE, b -> {
            if (this.solIndex < (this.recipeList.size() - 1) / (this.ref.col() * this.ref.row())) {
                ++this.solIndex;
                this.m_7856_();
            }
        });
        this.m_142416_((GuiEventListener)upButton);
        this.m_142416_((GuiEventListener)downButton);
    }

    private void renderSearchSearchText(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.searchBox == null) {
            return;
        }
        int startX = this.f_96543_ - this.f_97735_ - -this.searchTextDisplay.startX() - this.searchTextDisplay.width() - 1;
        int startY = this.visualZone.startY() + this.searchTextDisplay.startY();
        this.searchBox.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.searchBox.m_94213_() && this.searchBox.m_94155_().isEmpty() && !this.searchBox.m_93696_()) {
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.farmsoulkitchen.search").m_130940_(ChatFormatting.ITALIC), startX + 3, startY + 5, 0xF5F5F5);
        }
    }

    private void renderSearchBox(GuiGraphics graphics) {
        if (this.searchBox == null) {
            return;
        }
        int startX = this.f_96543_ - this.f_97735_ - -this.searchBoxDisplay.startX() - this.searchBoxDisplay.width() - 1;
        int startY = this.visualZone.startY() + this.searchBoxDisplay.startY();
        if (this.searchBox.m_94213_()) {
            startX -= this.searchTextDisplay.width();
        } else {
            graphics.m_280218_(TEXTURE, startX, startY, 0, 232, 18, 18);
        }
        graphics.m_280218_(TEXTURE, startX + 1, startY + 1, 0, 181, 16, 16);
    }

    private void drawSplitZoneCard(GuiGraphics graphics) {
        int startX = this.f_96543_ - this.f_97735_ - -this.typeDisplay.startX() - this.typeDisplay.width() - 2;
        int startY = this.visualZone.startY() + this.typeDisplay.startY();
        graphics.m_280509_(startX - 1, startY, startX, startY + this.typeDisplay.width(), Color.BLACK.getRGB());
    }

    private void drawScrollInfoBar(GuiGraphics graphics) {
        int startX = this.visualZone.startX() + this.scrollDisplay.startX();
        int startY = this.visualZone.startY() + this.scrollDisplay.startY();
        graphics.m_280218_(TEXTURE, startX, startY + 8, 189, 64, 9, 70);
        this.drawScrollIndicator(graphics, startX + 1, startY + 8 + 1);
    }

    private void drawScrollIndicator(GuiGraphics graphics, int startX, int startY) {
        if ((this.recipeList.size() - 1) / (this.ref.col() * this.ref.row()) >= 1) {
            graphics.m_280218_(TEXTURE, startX, startY + (int)(59.0f * this.getCurrentScroll()), 199, 64, 7, 9);
        } else {
            graphics.m_280218_(TEXTURE, startX, startY, 206, 64, 7, 9);
        }
    }

    private float getCurrentScroll() {
        return Mth.m_14036_((float)((float)((double)this.solIndex * (1.0 / (double)((this.recipeList.size() - 1) / (this.ref.col() * this.ref.row()))))), (float)0.0f, (float)1.0f);
    }
}

