/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.compat.builder.ai.ab;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.compat.builder.ai.ab.CustomABBehavior;
import com.github.wallev.farmsoulkitchen.util.function.Consumer3;
import com.github.wallev.farmsoulkitchen.util.function.Predicate3;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public abstract class CustomABBehaviorBuilder<T extends CustomABBehavior> {
    protected final ResourceLocation id;
    protected Consumer<T> acceptThis;
    protected Map<MemoryModuleType<?>, MemoryStatus> entryCondition;
    protected int minDuration;
    protected int maxDuration;
    protected Supplier<Behavior.Status> getStatus;
    protected Consumer3<ServerLevel, EntityMaid, Long> start;
    protected Consumer3<ServerLevel, EntityMaid, Long> tick;
    protected Consumer3<ServerLevel, EntityMaid, Long> stop;
    protected Predicate3<ServerLevel, EntityMaid, Long> canStillUse;
    protected Predicate<Long> timedOut;
    protected BiPredicate<ServerLevel, EntityMaid> checkExtraStartConditions;
    protected Predicate<EntityMaid> hasRequiredMemories;
    private boolean debug;
    private T t;

    public CustomABBehaviorBuilder(ResourceLocation id) {
        this.id = id;
    }

    public CustomABBehaviorBuilder(ResourceLocation id, boolean debug) {
        this.id = id;
        this.debug = debug;
    }

    public CustomABBehaviorBuilder<T> constructBehavior(Map<MemoryModuleType<?>, MemoryStatus> entryCondition) {
        this.entryCondition = entryCondition;
        return this;
    }

    public CustomABBehaviorBuilder<T> acceptThis(Consumer<T> iAcceptThis) {
        this.acceptThis = iAcceptThis;
        return this;
    }

    public CustomABBehaviorBuilder<T> getStatus(Supplier<Behavior.Status> getStatus) {
        this.getStatus = getStatus;
        return this;
    }

    public CustomABBehaviorBuilder<T> start(Consumer3<ServerLevel, EntityMaid, Long> start) {
        this.start = start;
        return this;
    }

    public CustomABBehaviorBuilder<T> tick(Consumer3<ServerLevel, EntityMaid, Long> tick) {
        this.tick = tick;
        return this;
    }

    public CustomABBehaviorBuilder<T> stop(Consumer3<ServerLevel, EntityMaid, Long> stop) {
        this.stop = stop;
        return this;
    }

    public CustomABBehaviorBuilder<T> canStillUse(Predicate3<ServerLevel, EntityMaid, Long> canStillUse) {
        this.canStillUse = canStillUse;
        return this;
    }

    public CustomABBehaviorBuilder<T> timedOut(Predicate<Long> timedOut) {
        this.timedOut = timedOut;
        return this;
    }

    public CustomABBehaviorBuilder<T> checkExtraStartConditions(BiPredicate<ServerLevel, EntityMaid> checkExtraStartConditions) {
        this.checkExtraStartConditions = checkExtraStartConditions;
        return this;
    }

    public CustomABBehaviorBuilder<T> hasRequiredMemories(Predicate<EntityMaid> hasRequiredMemories) {
        this.hasRequiredMemories = hasRequiredMemories;
        return this;
    }

    public T createObject() {
        if (this.debug) {
            return this.debugBuild();
        }
        return this.getT();
    }

    private T debugBuild() {
        if (this.t == null) {
            this.t = this.getT();
        } else {
            ((CustomABBehavior)((Object)this.t)).initBuilderData((CustomABBehaviorBuilder)this);
        }
        return this.t;
    }

    public T build() {
        return this.createObject();
    }

    protected abstract T getT();
}

