/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.compat.builder.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.wallev.farmsoulkitchen.compat.builder.task.ab.CustomTaskABBaseBuilder;
import com.github.wallev.farmsoulkitchen.compat.builder.task.builder.CustomTaskAttackBuilder;
import com.github.wallev.farmsoulkitchen.compat.builder.task.builder.CustomTaskBaseBuilder;
import com.github.wallev.farmsoulkitchen.compat.builder.task.builder.CustomTaskFarmBuilder;
import com.github.wallev.farmsoulkitchen.compat.builder.task.builder.CustomTaskFeedBuilder;
import com.github.wallev.farmsoulkitchen.compat.builder.task.builder.CustomTaskRangedAttackBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class CustomTaskBuilderManager {
    public static final CustomTaskBuilderManager INSTANCE = new CustomTaskBuilderManager();
    private Map<ResourceLocation, CustomTaskABBaseBuilder> customTaskMap = new HashMap<ResourceLocation, CustomTaskABBaseBuilder>();

    private CustomTaskBuilderManager() {
    }

    public CustomTaskBaseBuilder debugCreateTaskBase(String id) {
        ResourceLocation resourceLocation = this.createResourceLocation(id);
        return (CustomTaskBaseBuilder)this.customTaskMap.computeIfAbsent(resourceLocation, rec -> new CustomTaskBaseBuilder((ResourceLocation)rec, true));
    }

    public CustomTaskAttackBuilder debugCreateTaskAttack(String id) {
        ResourceLocation resourceLocation = this.createResourceLocation(id);
        return (CustomTaskAttackBuilder)this.customTaskMap.computeIfAbsent(resourceLocation, rec -> new CustomTaskAttackBuilder((ResourceLocation)rec, true));
    }

    public CustomTaskRangedAttackBuilder debugCreateTaskRangedAttack(String id) {
        ResourceLocation resourceLocation = this.createResourceLocation(id);
        return (CustomTaskRangedAttackBuilder)this.customTaskMap.computeIfAbsent(resourceLocation, rec -> new CustomTaskRangedAttackBuilder((ResourceLocation)rec, true));
    }

    public CustomTaskFeedBuilder debugCreateTaskFeed(String id) {
        ResourceLocation resourceLocation = this.createResourceLocation(id);
        return (CustomTaskFeedBuilder)this.customTaskMap.computeIfAbsent(resourceLocation, rec -> new CustomTaskFeedBuilder((ResourceLocation)rec, true));
    }

    public CustomTaskFarmBuilder debugCreateTaskFarm(String id) {
        ResourceLocation resourceLocation = this.createResourceLocation(id);
        TouhouLittleMaid.LOGGER.info("debugCreateTaskFarm: " + resourceLocation);
        TouhouLittleMaid.LOGGER.info("debugCreateTaskFarm: " + this.customTaskMap.get(resourceLocation));
        return (CustomTaskFarmBuilder)this.customTaskMap.computeIfAbsent(resourceLocation, rec -> new CustomTaskFarmBuilder((ResourceLocation)rec, true));
    }

    public CustomTaskBaseBuilder createCustomTaskBase(String id) {
        ResourceLocation resourceLocation = this.createResourceLocation(id);
        return CustomTaskBaseBuilder.create(resourceLocation);
    }

    public CustomTaskAttackBuilder createCustomTaskAttack(String id) {
        ResourceLocation resourceLocation = this.createResourceLocation(id);
        return CustomTaskAttackBuilder.create(resourceLocation);
    }

    public CustomTaskRangedAttackBuilder createCustomTaskRangedAttack(String id) {
        ResourceLocation resourceLocation = this.createResourceLocation(id);
        return CustomTaskRangedAttackBuilder.create(resourceLocation);
    }

    public CustomTaskFeedBuilder createCustomTaskFeed(String id) {
        ResourceLocation resourceLocation = this.createResourceLocation(id);
        return CustomTaskFeedBuilder.create(resourceLocation);
    }

    public CustomTaskFarmBuilder createCustomTaskFarm(String id) {
        ResourceLocation resourceLocation = this.createResourceLocation(id);
        return CustomTaskFarmBuilder.create(resourceLocation);
    }

    public void clearCustomTask() {
    }

    private ResourceLocation createResourceLocation(String name) {
        return new ResourceLocation("touhoulittlemaid", "custom_task." + name);
    }
}

