/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.entity.data.inner.task;

import com.github.wallev.farmsoulkitchen.entity.data.inner.task.ITaskData;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;

public class CookData
implements ITaskData {
    public static final Codec<List<String>> LIST_CODEC = Codec.STRING.listOf().xmap(Lists::newArrayList, Function.identity());
    public static final Codec<CookData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("Mode").forGetter(CookData::mode), (App)LIST_CODEC.fieldOf("Recs").forGetter(CookData::recs)).apply((Applicative)instance, CookData::new));
    private String mode;
    private List<String> recs;

    public CookData() {
        this(Mode.RANDOM.name, Lists.newArrayList());
    }

    public CookData(String mode, List<String> recs) {
        this.mode = mode;
        this.recs = recs;
    }

    public void addRec(String rec) {
        this.recs.add(rec);
    }

    public void removeRec(String rec) {
        this.recs.remove(rec);
    }

    public void addOrRemoveRec(String rec) {
        if (this.recs.contains(rec)) {
            this.recs.remove(rec);
        } else {
            this.recs.add(rec);
        }
    }

    public void setRecs(List<String> recs) {
        this.recs = recs;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<String> recs() {
        return this.recs;
    }

    public String mode() {
        return this.mode;
    }

    public static enum Mode {
        RANDOM("random"),
        SELECT("select");

        public final String name;

        private Mode(String select) {
            this.name = select;
        }
    }
}

