/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.handler;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.init.InitItems;
import com.github.wallev.farmsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.farmsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.farmsoulkitchen.task.cook.handler.CookBagInventory;
import com.github.wallev.farmsoulkitchen.task.cook.handler.ICookInventory;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidInventory;
import com.github.wallev.farmsoulkitchen.task.cook.handler.compat.InventoryCompat;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaidRecipesManager<R extends Recipe<? extends Container>> {
    protected final List<R> rec = new ArrayList<R>();
    protected final List<R> currentRecs = new ArrayList<R>();
    private final EntityMaid maid;
    private final Level level;
    private final ICookTask<?, R> task;
    private final boolean single;
    private ICookInventory cookInv;
    private boolean hasCulinaryHub;
    private Map<BagType, List<BlockPos>> bindingPoses;
    private String lastTaskRule;
    private List<String> recipeIds;
    private int repeatTimes = 0;
    private List<Pair<List<Integer>, List<List<ItemStack>>>> recipesIngredients = new ArrayList<Pair<List<Integer>, List<List<ItemStack>>>>();
    private int tryTime = 0;

    public MaidRecipesManager(EntityMaid maid, ICookTask<?, R> task, boolean single) {
        this(maid, task, single, true);
    }

    public MaidRecipesManager(EntityMaid maid, ICookTask<?, R> task, boolean single, boolean createRecIng) {
        this.maid = maid;
        this.level = maid.f_19853_;
        this.single = single;
        this.task = task;
        if (createRecIng) {
            this.createRecipesIngredients();
        }
    }

    public static void makeChanged(BlockEntity tile) {
        tile.m_6596_();
        Level world = tile.m_58904_();
        if (world != null) {
            world.m_7260_(tile.m_58899_(), tile.m_58900_(), tile.m_58900_(), 3);
        }
    }

    private boolean initInvData() {
        if (this.cookInv == null || this.bindingPoses == null || !this.hasCulinaryHub && !this.findCulinaryHub().m_41619_()) {
            this.hasCulinaryHub = !this.findCulinaryHub().m_41619_();
            this.bindingPoses = ItemCulinaryHub.getBindPoses(this.findCulinaryHub());
            this.cookInv = this.initCookInv();
            return true;
        }
        return false;
    }

    private ICookInventory initCookInv() {
        ItemStack culinaryHub = this.findCulinaryHub();
        return culinaryHub.m_41619_() ? new MaidInventory(this.maid) : new CookBagInventory(culinaryHub);
    }

    public ItemStack findCulinaryHub() {
        ItemStack culinaryHubItem = this.maid.getMaidInv().getStackInSlot(4);
        if (culinaryHubItem.m_150930_((Item)InitItems.CULINARY_HUB.get())) {
            return culinaryHubItem;
        }
        return ItemStack.f_41583_;
    }

    private void tranCookBag2Chest(BagType bagType, boolean requireHasItem) {
        if (!this.hasCulinaryHub) {
            return;
        }
        List<BlockPos> ingredientPos = this.getBindingTypePoses(bagType);
        if (ingredientPos.isEmpty()) {
            return;
        }
        IItemHandlerModifiable itemStackHandler = this.getBagContainerInv(bagType);
        block0: for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            ItemStack stack = itemStackHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            for (BlockPos ingredientPo : ingredientPos) {
                BlockEntity blockEntity;
                if (this.isPosZone(ingredientPo) || (blockEntity = this.maid.f_19853_.m_7702_(ingredientPo)) == null) continue;
                if (stack.m_41619_()) continue block0;
                for (IChestType type : ChestManager.getAllChestTypes()) {
                    if (!type.isChest(blockEntity) || type.getOpenCount((BlockGetter)this.maid.f_19853_, ingredientPo, blockEntity) > 0) continue;
                    blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(beInv -> {
                        ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)beInv, (ItemStack)stack.m_41777_(), (boolean)false);
                        stack.m_41774_(stack.m_41613_() - leftStack.m_41613_());
                    });
                    MaidRecipesManager.makeChanged(blockEntity);
                    break;
                }
                if (!InventoryCompat.insertSopBe(stack, blockEntity, requireHasItem)) continue;
                continue block0;
            }
        }
        this.getCookInv().syncInv();
    }

    private List<BlockPos> getBindingTypePoses(BagType bagType) {
        return this.bindingPoses.getOrDefault((Object)bagType, Collections.emptyList());
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    public boolean isSingle() {
        return this.single;
    }

    private List<R> getRecs() {
        ArrayList<R> list = new ArrayList<R>(this.rec);
        this.shuffle(list);
        return list;
    }

    public List<Pair<List<Integer>, List<List<ItemStack>>>> getRecipesIngredients() {
        return this.recipesIngredients;
    }

    public Pair<List<Integer>, List<List<ItemStack>>> getRecipeIngredient() {
        if (this.recipesIngredients.isEmpty()) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        int size = this.recipesIngredients.size();
        Pair<List<Integer>, List<List<ItemStack>>> integerListPair = this.recipesIngredients.get(0);
        List<Pair<List<Integer>, List<List<ItemStack>>>> pairs = this.recipesIngredients.subList(1, size);
        this.recipesIngredients = pairs;
        return integerListPair;
    }

    public boolean checkAndCreateRecipesIngredients() {
        Level level;
        if (this.hasCulinaryHub && this.findCulinaryHub().m_41619_() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.recipesIngredients.clear();
            this.maid.refreshBrain(serverLevel);
            return false;
        }
        this.init();
        if (!this.recipesIngredients.isEmpty()) {
            return true;
        }
        boolean lastInv = this.isLastCookInv();
        if (lastInv && this.tryTime++ < 10) {
            return true;
        }
        this.tryTime = 0;
        this.createRecipesIngredients();
        return true;
    }

    private boolean initTaskData() {
        if (this.lastTaskRule == null || this.recipeIds == null) {
            ICookTask cookTask = (ICookTask)this.maid.getTask();
            CookData cookData = (CookData)cookTask.getTaskData(this.maid);
            this.lastTaskRule = cookData.mode();
            this.recipeIds = cookData.recs();
            this.rec.clear();
            List<R> allRecipesFor = this.getValidRecipesFor();
            this.rec.addAll(allRecipesFor);
            return true;
        }
        return false;
    }

    private List<R> getValidRecipesFor() {
        List<Object> allRecipesFor = CookData.Mode.SELECT.name.equals(this.lastTaskRule) ? this.task.getRecipes(this.level).stream().filter(r -> this.recipeIds.contains(r.m_6423_().toString())).toList() : this.task.getRecipes(this.level);
        return allRecipesFor;
    }

    private boolean isLastCookInv() {
        CombinedInvWrapper availableInv = this.maid.getAvailableInv(true);
        List<ItemStack> lastInvStack = this.cookInv.getLastInvStack();
        ItemStack culinaryHub = this.findCulinaryHub();
        if (!culinaryHub.m_41619_()) {
            IItemHandlerModifiable availableInv1 = this.getCookInv().getAvailableInv(this.maid, BagType.INGREDIENT);
            if (availableInv1.getSlots() != lastInvStack.size()) {
                return false;
            }
            for (int i = 0; i < availableInv1.getSlots(); ++i) {
                ItemStack cacheStack;
                ItemStack stackInSlot = availableInv1.getStackInSlot(i);
                if (stackInSlot.m_150930_((cacheStack = lastInvStack.get(i)).m_41720_()) && stackInSlot.m_41613_() == cacheStack.m_41613_()) continue;
                return false;
            }
        } else {
            if (availableInv.getSlots() != lastInvStack.size()) {
                return false;
            }
            for (int i = 0; i < availableInv.getSlots(); ++i) {
                ItemStack cacheStack;
                ItemStack stackInSlot = availableInv.getStackInSlot(i);
                if (stackInSlot.m_150930_((cacheStack = lastInvStack.get(i)).m_41720_()) && stackInSlot.m_41613_() == cacheStack.m_41613_()) continue;
                return false;
            }
        }
        return true;
    }

    public void mapChestIngredient() {
        List<Pair<List<Integer>, List<Item>>> _make;
        if (!this.hasCulinaryHub) {
            return;
        }
        List<BlockPos> ingredientPos = this.getBindingTypePoses(BagType.INGREDIENT);
        if (ingredientPos.isEmpty()) {
            return;
        }
        IItemHandlerModifiable inventory = this.getCookInv().getAvailableInv(this.maid, BagType.INGREDIENT);
        HashMap<Item, Integer> available = new HashMap<Item, Integer>();
        HashMap<Item, List<ItemStack>> ingredientAmount = new HashMap<Item, List<ItemStack>>();
        HashMap<ItemStack, Pair<IItemHandler, Integer>> stackContentHandler = new HashMap<ItemStack, Pair<IItemHandler, Integer>>();
        for (BlockPos ingredientPo : ingredientPos) {
            BlockEntity blockEntity;
            if (this.isPosZone(ingredientPo) || (blockEntity = this.level.m_7702_(ingredientPo)) == null) continue;
            for (IChestType type : ChestManager.getAllChestTypes()) {
                if (!type.isChest(blockEntity) || type.getOpenCount((BlockGetter)this.maid.f_19853_, ingredientPo, blockEntity) > 0) continue;
                blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(beInv -> {
                    for (int i = 0; i < beInv.getSlots(); ++i) {
                        ItemStack stackInSlot = beInv.getStackInSlot(i);
                        Item item = stackInSlot.m_41720_();
                        if (stackInSlot.m_41619_()) continue;
                        stackContentHandler.put(stackInSlot, Pair.of((Object)beInv, (Object)i));
                        available.merge(item, stackInSlot.m_41613_(), Integer::sum);
                        List itemStacks = (List)ingredientAmount.get(item);
                        if (itemStacks == null) {
                            ingredientAmount.put(item, Lists.newArrayList((Object[])new ItemStack[]{stackInSlot}));
                            continue;
                        }
                        itemStacks.add(stackInSlot);
                    }
                });
                break;
            }
            if (!InventoryCompat.sopStorageItemData(blockEntity, stackContentHandler, available, ingredientAmount)) continue;
            break;
        }
        if ((_make = this.createIngres(available, false)).isEmpty()) {
            return;
        }
        for (Pair<List<Integer>, List<Item>> listListPair : _make) {
            List first = (List)listListPair.getFirst();
            List second = (List)listListPair.getSecond();
            block3: for (int i = 0; i < first.size(); ++i) {
                Integer i1 = (Integer)first.get(i);
                Item item = (Item)second.get(i);
                if (i1 <= 0 || item == null) continue;
                List itemStacks = (List)ingredientAmount.get(item);
                for (ItemStack itemStack : itemStacks) {
                    ItemStack itemStack1;
                    ItemStack copy;
                    if (itemStack.m_41619_()) continue;
                    int count = itemStack.m_41613_();
                    Pair iTrackedContentsItemHandlerIntegerPair = (Pair)stackContentHandler.get(itemStack);
                    IItemHandler first1 = (IItemHandler)iTrackedContentsItemHandlerIntegerPair.getFirst();
                    Integer second1 = (Integer)iTrackedContentsItemHandlerIntegerPair.getSecond();
                    if (i1 - count <= 0) {
                        copy = itemStack.m_255036_(i1.intValue());
                        itemStack1 = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)copy, (boolean)false);
                        first1.extractItem(second1.intValue(), i1 - itemStack1.m_41613_(), false);
                        continue block3;
                    }
                    copy = itemStack.m_41777_();
                    itemStack1 = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)copy, (boolean)false);
                    first1.extractItem(second1.intValue(), itemStack.m_41613_() - itemStack1.m_41613_(), false);
                    i1 = i1 - count;
                }
            }
        }
        for (BlockPos ingredientPo : ingredientPos) {
            BlockEntity blockEntity;
            if (this.isPosZone(ingredientPo) || (blockEntity = this.level.m_7702_(ingredientPo)) == null) continue;
            MaidRecipesManager.makeChanged(blockEntity);
        }
        this.getCookInv().syncInv();
    }

    private boolean isPosZone(BlockPos ingredientPo) {
        float maxDistance = this.maid.m_21535_();
        return this.maid.m_20275_((double)ingredientPo.m_123341_(), (double)ingredientPo.m_123342_(), (double)ingredientPo.m_123343_()) > (double)(maxDistance * maxDistance);
    }

    private void init() {
        boolean initTaskData = this.initTaskData();
        boolean initInvData = this.initInvData();
        if (initTaskData || initInvData) {
            this.recipesIngredients.clear();
        }
    }

    private void createRecipesIngredients() {
        this.init();
        this.currentRecs.clear();
        this.currentRecs.addAll(this.getRecs());
        this.tranUnIngre2Chest();
        this.mapChestIngredient();
        this.cookInv.refreshInv();
        this.createIngres(true);
        this.currentRecs.clear();
    }

    public void tranOutput2Chest() {
        this.tranCookBag2Chest(BagType.OUTPUT, false);
    }

    public void tranUnIngre2Chest() {
        this.tranCookBag2Chest(BagType.INGREDIENT, true);
    }

    private void createIngres(boolean setRecipeIngres) {
        Map<Item, Integer> maidAvailableInv = this.getMaidAvailableInv();
        this.createIngres(maidAvailableInv, setRecipeIngres);
    }

    protected List<Pair<List<Integer>, List<Item>>> createIngres(Map<Item, Integer> available, boolean setRecipeIngres) {
        List<Pair<List<Integer>, List<Item>>> _make = this.getRecIngreMake(available);
        if (setRecipeIngres) {
            this.setRecIngres(_make, available);
        }
        return _make;
    }

    @NotNull
    private List<Pair<List<Integer>, List<Item>>> getRecIngreMake(Map<Item, Integer> available) {
        ArrayList<Pair<List<Integer>, List<Item>>> _make = new ArrayList<Pair<List<Integer>, List<Item>>>();
        for (Recipe r : this.currentRecs) {
            Pair<List<Integer>, List<Item>> maxCount = this.getAmountIngredient(r, available);
            if (((List)maxCount.getFirst()).isEmpty()) continue;
            _make.add((Pair<List<Integer>, List<Item>>)Pair.of((Object)((List)maxCount.getFirst()), (Object)((List)maxCount.getSecond())));
        }
        this.repeat(_make, available, this.repeatTimes);
        return _make;
    }

    protected void setRecIngres(List<Pair<List<Integer>, List<Item>>> _make, Map<Item, Integer> available) {
        if (_make.isEmpty()) {
            return;
        }
        this.recipesIngredients = this.transform(_make, available);
    }

    @NotNull
    protected Map<Item, Integer> getMaidAvailableInv() {
        return new HashMap<Item, Integer>(this.getCookInv().getInventoryItem());
    }

    public ICookInventory getCookInv() {
        return this.cookInv;
    }

    protected void repeat(List<Pair<List<Integer>, List<Item>>> oriList, Map<Item, Integer> available, int times) {
        ArrayList<Pair<List<Integer>, List<Item>>> oriPairs = new ArrayList<Pair<List<Integer>, List<Item>>>(oriList);
        for (int l = 0; l < times; ++l) {
            for (Pair<List<Integer>, List<Item>> listListPair : oriPairs) {
                int i;
                List first = (List)listListPair.getFirst();
                List second = (List)listListPair.getSecond();
                boolean canRepeat = true;
                for (i = 0; i < second.size(); ++i) {
                    Integer availableCount = available.get(second.get(i));
                    if (availableCount >= (Integer)first.get(i)) continue;
                    canRepeat = false;
                    break;
                }
                if (!canRepeat) continue;
                for (i = 0; i < second.size(); ++i) {
                    Item item = (Item)second.get(i);
                    available.put(item, available.get(item) - (Integer)first.get(i));
                }
                oriList.add(listListPair);
            }
        }
    }

    protected List<Pair<List<Integer>, List<List<ItemStack>>>> transform(List<Pair<List<Integer>, List<Item>>> oriList, Map<Item, Integer> available) {
        Map<Item, List<ItemStack>> inventoryStack = this.getCookInv().getInventoryStack();
        List<Pair<List<Integer>, List<List<ItemStack>>>> list1 = oriList.stream().map(p -> {
            List<List> list = ((List)p.getSecond()).stream().map(item -> (List)inventoryStack.get(item)).toList();
            return Pair.of((Object)((List)p.getFirst()), list);
        }).toList();
        return list1;
    }

    protected Pair<List<Integer>, List<Item>> getAmountIngredient(R recipe, Map<Item, Integer> available) {
        NonNullList<Ingredient> ingredients = this.task.getIngredients((Recipe<?>)recipe);
        ArrayList<Item> invIngredient = new ArrayList<Item>();
        HashMap<Item, Integer> itemTimes = new HashMap<Item, Integer>();
        boolean[] canMake = new boolean[]{true};
        boolean[] single = new boolean[]{false};
        this.extraStartRecipe(recipe, available, canMake, single, itemTimes, invIngredient);
        for (Object ingredient : ingredients) {
            boolean hasIngredient = false;
            for (Item item : available.keySet()) {
                ItemStack stack = item.m_7968_();
                if (!ingredient.test(stack)) continue;
                invIngredient.add(item);
                hasIngredient = true;
                if (stack.m_41741_() == 1) {
                    single[0] = true;
                    itemTimes.put(item, 1);
                    break;
                }
                itemTimes.merge(item, 1, Integer::sum);
                break;
            }
            if (hasIngredient) continue;
            canMake[0] = false;
            itemTimes.clear();
            invIngredient.clear();
            break;
        }
        this.extraEndRecipe(recipe, available, canMake, single, itemTimes, invIngredient);
        if (!canMake[0] || itemTimes.entrySet().stream().anyMatch(entry -> (Integer)available.get(entry.getKey()) < (Integer)entry.getValue())) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        int maxCount = 64;
        if (single[0] || this.single) {
            maxCount = 1;
        } else {
            for (Item item : itemTimes.keySet()) {
                maxCount = Math.min(maxCount, item.m_7968_().m_41741_());
                maxCount = Math.min(maxCount, available.get(item) / (Integer)itemTimes.get(item));
            }
        }
        ArrayList<Integer> countList = new ArrayList<Integer>();
        for (Item item : invIngredient) {
            countList.add(maxCount);
            available.put(item, available.get(item) - maxCount);
        }
        return Pair.of(countList, invIngredient);
    }

    protected boolean extraStartRecipe(R recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
        return true;
    }

    protected boolean extraEndRecipe(R recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
        return true;
    }

    private void shuffle(List<R> recipes) {
        Collections.shuffle(recipes);
    }

    public void shrinkOutputAdditionItem(ItemStack findItem, int count) {
        if (this.hasCulinaryHub) {
            IItemHandlerModifiable availableInv = this.getOutputAdditionInv();
            int additionSlot = ItemsUtil.findStackSlot((IItemHandler)availableInv, stack -> stack.m_150930_(findItem.m_41720_()));
            if (additionSlot > -1) {
                availableInv.extractItem(additionSlot, count, false);
                this.cookInv.syncInv();
            } else {
                List<BlockPos> bindModePoses = this.getBindingTypePoses(BagType.OUTPUT_ADDITION);
                this.shrinkAdditionStackFromHub(findItem, bindModePoses, this.level, count);
            }
        } else {
            CombinedInvWrapper maidInv = this.maid.getAvailableInv(true);
            int additionSlot = ItemsUtil.findStackSlot((IItemHandler)maidInv, stack -> stack.m_150930_(findItem.m_41720_()));
            if (additionSlot > -1) {
                maidInv.extractItem(additionSlot, count, false);
            }
        }
    }

    public int getOutputAdditionItemCount(ItemStack findItem) {
        if (this.hasCulinaryHub) {
            IItemHandlerModifiable availableInv = this.getOutputAdditionInv();
            int additionSlot = ItemsUtil.findStackSlot((IItemHandler)availableInv, stack -> stack.m_150930_(findItem.m_41720_()));
            if (additionSlot > -1) {
                return availableInv.getStackInSlot(additionSlot).m_41613_();
            }
            List<BlockPos> bindModePoses = this.getBindingTypePoses(BagType.OUTPUT_ADDITION);
            return this.getAdditionStackFromHubCount(findItem, bindModePoses, this.level);
        }
        CombinedInvWrapper maidInv = this.maid.getAvailableInv(true);
        int additionSlot = ItemsUtil.findStackSlot((IItemHandler)maidInv, stack -> stack.m_150930_(findItem.m_41720_()));
        if (additionSlot > -1) {
            return maidInv.getStackInSlot(additionSlot).m_41613_();
        }
        return 0;
    }

    public boolean hasOutputAdditionItem(ItemStack findItem) {
        if (this.hasCulinaryHub) {
            IItemHandlerModifiable availableInv = this.getOutputAdditionInv();
            int additionSlot = ItemsUtil.findStackSlot((IItemHandler)availableInv, stack -> stack.m_150930_(findItem.m_41720_()));
            if (additionSlot > -1) {
                return true;
            }
            List<BlockPos> bindModePoses = this.getBindingTypePoses(BagType.OUTPUT_ADDITION);
            return this.hasAdditionStackFromHub(findItem, bindModePoses, this.level);
        }
        return ItemsUtil.findStackSlot((IItemHandler)this.maid.getAvailableInv(true), stack -> stack.m_150930_(findItem.m_41720_())) > -1;
    }

    public ItemStack findOutputAdditionItem(ItemStack findItem) {
        if (this.hasCulinaryHub) {
            IItemHandlerModifiable availableInv = this.getOutputAdditionInv();
            int additionSlot = ItemsUtil.findStackSlot((IItemHandler)availableInv, stack -> stack.m_150930_(findItem.m_41720_()));
            if (additionSlot > -1) {
                ItemStack itemStack = availableInv.extractItem(additionSlot, 64, false);
                this.cookInv.syncInv();
                return itemStack.m_41777_();
            }
            List<BlockPos> bindModePoses = this.getBindingTypePoses(BagType.OUTPUT_ADDITION);
            return this.getAdditionStackFromHub(findItem, bindModePoses, this.level);
        }
        CombinedInvWrapper maidInv = this.maid.getAvailableInv(true);
        int additionSlot = ItemsUtil.findStackSlot((IItemHandler)maidInv, stack -> stack.m_150930_(findItem.m_41720_()));
        if (additionSlot > -1) {
            ItemStack stackInSlot = maidInv.getStackInSlot(additionSlot);
            ItemStack copy = stackInSlot.m_41777_();
            stackInSlot.m_41764_(0);
            return copy;
        }
        return ItemStack.f_41583_;
    }

    private boolean hasAdditionStackFromHub(ItemStack findItem, List<BlockPos> bindModePoses, Level level) {
        for (BlockPos bindModePose : bindModePoses) {
            LazyOptional capability;
            BlockEntity blockEntity;
            if (this.isPosZone(bindModePose) || (blockEntity = level.m_7702_(bindModePose)) == null || !(capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent()) continue;
            IItemHandler beInv = (IItemHandler)capability.resolve().get();
            return ItemsUtil.findStackSlot((IItemHandler)beInv, stack -> stack.m_150930_(findItem.m_41720_())) > -1;
        }
        return false;
    }

    private int getAdditionStackFromHubCount(ItemStack findItem, List<BlockPos> bindModePoses, Level level) {
        for (BlockPos bindModePose : bindModePoses) {
            IItemHandler beInv;
            int stackSlot;
            LazyOptional capability;
            BlockEntity blockEntity;
            if (this.isPosZone(bindModePose) || (blockEntity = level.m_7702_(bindModePose)) == null || !(capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent() || (stackSlot = ItemsUtil.findStackSlot((IItemHandler)(beInv = (IItemHandler)capability.resolve().get()), stack -> stack.m_150930_(findItem.m_41720_()))) <= -1) continue;
            return beInv.getStackInSlot(stackSlot).m_41613_();
        }
        return 0;
    }

    private void shrinkAdditionStackFromHub(ItemStack findItem, List<BlockPos> bindModePoses, Level level, int count) {
        for (BlockPos bindModePose : bindModePoses) {
            IItemHandler beInv;
            int stackSlot;
            LazyOptional capability;
            BlockEntity blockEntity;
            if (this.isPosZone(bindModePose) || (blockEntity = level.m_7702_(bindModePose)) == null || !(capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent() || (stackSlot = ItemsUtil.findStackSlot((IItemHandler)(beInv = (IItemHandler)capability.resolve().get()), stack -> stack.m_150930_(findItem.m_41720_()))) <= -1) continue;
            beInv.extractItem(stackSlot, count, false).m_41777_();
            return;
        }
    }

    private ItemStack getAdditionStackFromHub(ItemStack findItem, List<BlockPos> bindModePoses, Level level) {
        for (BlockPos bindModePose : bindModePoses) {
            IItemHandler beInv;
            int stackSlot;
            LazyOptional capability;
            BlockEntity blockEntity;
            if (this.isPosZone(bindModePose) || (blockEntity = level.m_7702_(bindModePose)) == null || !(capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent() || (stackSlot = ItemsUtil.findStackSlot((IItemHandler)(beInv = (IItemHandler)capability.resolve().get()), stack -> stack.m_150930_(findItem.m_41720_()))) <= -1) continue;
            ItemStack copy = beInv.extractItem(stackSlot, 64, false).m_41777_();
            blockEntity.m_6596_();
            return copy;
        }
        return ItemStack.f_41583_;
    }

    public IItemHandlerModifiable getOutputInv() {
        return this.getBagContainerInv(BagType.OUTPUT);
    }

    public IItemHandlerModifiable getOutputAdditionInv() {
        return this.getBagContainerInv(BagType.OUTPUT_ADDITION);
    }

    public IItemHandlerModifiable getInputInv() {
        return this.getBagContainerInv(BagType.INGREDIENT);
    }

    private IItemHandlerModifiable getBagContainerInv(BagType bagType) {
        return this.getCookInv().getAvailableInv(this.maid, bagType);
    }

    @Nullable
    public IItemHandlerModifiable getIngredientInv() {
        return this.getInputInv();
    }
}

