/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.handler.compat;

import com.github.wallev.farmsoulkitchen.foundation.utility.Mods;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;

public class SophistorageCompat {
    protected static void insertItem(ItemStack itemStack, StorageBlockEntity storageBlockEntity, boolean requireHasItem) {
        StorageWrapper storageWrapper = storageBlockEntity.getStorageWrapper();
        if (!requireHasItem) {
            InventoryHandler inventoryHandler = storageWrapper.getInventoryHandler();
            ItemStack leftStack = inventoryHandler.insertItem(itemStack.m_41777_(), false);
            itemStack.m_41774_(itemStack.m_41613_() - leftStack.m_41613_());
            storageBlockEntity.m_6596_();
            WorldHelper.notifyBlockUpdate((BlockEntity)storageBlockEntity);
        } else {
            ITrackedContentsItemHandler inventoryHandler = storageWrapper.getInventoryForInputOutput();
            ItemStack leftStack = inventoryHandler.insertItem(itemStack.m_41777_(), false);
            itemStack.m_41774_(itemStack.m_41613_() - leftStack.m_41613_());
            storageBlockEntity.m_6596_();
            WorldHelper.notifyBlockUpdate((BlockEntity)storageBlockEntity);
        }
    }

    protected static void mapItemData(StorageBlockEntity storageBlockEntity, Map<ItemStack, Pair<IItemHandler, Integer>> stackContentHandler, Map<Item, Integer> available, Map<Item, List<ItemStack>> ingredientAmount) {
        StorageWrapper storageWrapper = storageBlockEntity.getStorageWrapper();
        ITrackedContentsItemHandler inventoryForInputOutput = storageWrapper.getInventoryForInputOutput();
        for (int i = 0; i < inventoryForInputOutput.getSlots(); ++i) {
            ItemStack stackInSlot = inventoryForInputOutput.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            Item item = stackInSlot.m_41720_();
            available.merge(item, stackInSlot.m_41613_(), Integer::sum);
            stackContentHandler.put(stackInSlot, (Pair<IItemHandler, Integer>)Pair.of((Object)inventoryForInputOutput, (Object)i));
            List<ItemStack> itemStacks = ingredientAmount.get(item);
            if (itemStacks == null) {
                ingredientAmount.put(item, Lists.newArrayList((Object[])new ItemStack[]{stackInSlot}));
                continue;
            }
            itemStacks.add(stackInSlot);
        }
    }

    protected static boolean storageItemData(BlockEntity blockEntity, Map<ItemStack, Pair<IItemHandler, Integer>> stackContentHandler, Map<Item, Integer> available, Map<Item, List<ItemStack>> ingredientAmount) {
        if (Mods.SOPHISTICATED_STORAGE.isLoaded && blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity storageBlockEntity = (StorageBlockEntity)blockEntity;
            SophistorageCompat.mapItemData(storageBlockEntity, stackContentHandler, available, ingredientAmount);
            return true;
        }
        return false;
    }

    protected static boolean insert(ItemStack itemStack, BlockEntity blockEntity, boolean requireHasItem) {
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity storageBlockEntity = (StorageBlockEntity)blockEntity;
            SophistorageCompat.insertItem(itemStack, storageBlockEntity, requireHasItem);
            return true;
        }
        return false;
    }

    protected static boolean isStorageBe(BlockEntity blockEntity) {
        boolean bl;
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity storageBlockEntity = (StorageBlockEntity)blockEntity;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }
}

