/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.v1.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.farmsoulkitchen.task.cook.v1.common.TaskLdBaseContainerCook;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class TaskLdContainerCook<B extends BlockEntity, R extends Recipe<? extends Container>>
extends TaskLdBaseContainerCook<B, R> {
    @Override
    public void insertInputStack(Container inventory, IItemHandlerModifiable availableInv, BlockEntity blockEntity, Pair<List<Integer>, List<List<ItemStack>>> ingredientPair) {
        List ingredients;
        List amounts = (List)ingredientPair.getFirst();
        if (this.hasEnoughIngredient(amounts, ingredients = (List)ingredientPair.getSecond())) {
            int i = this.getInputStartSlot();
            int j = 0;
            while (i < ingredients.size() + this.getInputStartSlot()) {
                if (ingredients.get(j) != null && !((List)ingredients.get(j)).isEmpty()) {
                    this.insertAndShrink(inventory, (Integer)amounts.get(j), ingredients, j, i);
                }
                ++i;
                ++j;
            }
            blockEntity.m_6596_();
        }
        this.updateIngredient(ingredientPair);
    }

    @Override
    public boolean hasEnoughIngredient(List<Integer> amounts, List<List<ItemStack>> ingredients) {
        boolean canInsert = true;
        int i = 0;
        for (List<ItemStack> ingredient : ingredients) {
            if (ingredient == null || ingredient.isEmpty()) continue;
            int actualCount = amounts.get(i++);
            for (ItemStack itemStack : ingredient) {
                if ((actualCount -= itemStack.m_41613_()) <= 0) break;
            }
            if (actualCount <= 0) continue;
            canInsert = false;
            break;
        }
        return canInsert;
    }

    @Override
    public MaidRecipesManager<R> getRecipesManager(EntityMaid maid) {
        return new MaidRecipesManager<R>(maid, this, false){

            @Override
            protected Pair<List<Integer>, List<Item>> getAmountIngredient(R recipe, Map<Item, Integer> available) {
                NonNullList ingredients = recipe.m_7527_();
                boolean[] canMake = new boolean[]{true};
                boolean[] single = new boolean[]{false};
                HashMap<Item, Integer> itemTimes = new HashMap<Item, Integer>();
                ArrayList<Item> invIngredient = new ArrayList<Item>();
                boolean hasStartContainer = this.extraStartRecipe(recipe, available, canMake, single, itemTimes, invIngredient);
                if (!hasStartContainer) {
                    return Pair.of((Object)Collections.EMPTY_LIST, (Object)Collections.EMPTY_LIST);
                }
                for (Ingredient ingredient : ingredients) {
                    boolean hasIngredient = false;
                    for (Item item2 : available.keySet()) {
                        ItemStack stack = item2.m_7968_();
                        if (!ingredient.test(stack)) continue;
                        invIngredient.add(item2);
                        hasIngredient = true;
                        if (stack.m_41741_() == 1) {
                            single[0] = true;
                            itemTimes.put(item2, 1);
                            break;
                        }
                        itemTimes.merge(item2, 1, Integer::sum);
                        break;
                    }
                    if (hasIngredient) continue;
                    canMake[0] = false;
                    itemTimes.clear();
                    invIngredient.clear();
                    break;
                }
                int size = ingredients.size();
                int il = TaskLdContainerCook.this.getInputSize() - 1 - size;
                if (canMake[0] && il > 0) {
                    for (int i = 0; i < il; ++i) {
                        invIngredient.add(null);
                    }
                }
                boolean hasEndContainer = this.extraEndRecipe(recipe, available, canMake, single, itemTimes, invIngredient);
                if (!canMake[0] || !hasEndContainer || invIngredient.stream().anyMatch(item -> {
                    if (item == null) {
                        return false;
                    }
                    return (Integer)available.get(item) <= 0;
                })) {
                    return Pair.of((Object)Collections.EMPTY_LIST, (Object)Collections.EMPTY_LIST);
                }
                int maxCount = 64;
                if (single[0] || this.isSingle()) {
                    maxCount = 1;
                } else {
                    for (Item item3 : itemTimes.keySet()) {
                        if (item3 == null) continue;
                        maxCount = Math.min(maxCount, available.get(item3) / (Integer)itemTimes.get(item3));
                    }
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (Item item4 : invIngredient) {
                    if (item4 == null) {
                        arrayList.add(0);
                        continue;
                    }
                    arrayList.add(maxCount);
                    available.put(item4, available.get(item4) - maxCount);
                }
                return Pair.of(arrayList, invIngredient);
            }

            @Override
            protected boolean extraStartRecipe(R recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
                return TaskLdContainerCook.this.tExtraStartRecipe(recipe, available, single, canMake, itemTimes, invIngredient);
            }

            @Override
            protected boolean extraEndRecipe(R recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
                return TaskLdContainerCook.this.tExtraEndRecipe(recipe, available, single, canMake, itemTimes, invIngredient);
            }
        };
    }

    protected boolean tExtraStartRecipe(R recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
        return true;
    }

    protected boolean tExtraEndRecipe(R recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
        return true;
    }

    protected boolean extraRecipe(Item extraItem, R recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
        boolean hasIngredient = false;
        for (Item item : available.keySet()) {
            ItemStack stack = item.m_7968_();
            if (!stack.m_150930_(extraItem)) continue;
            invIngredient.add(item);
            hasIngredient = true;
            if (stack.m_41741_() == 1) {
                single[0] = true;
                itemTimes.put(item, 1);
                break;
            }
            itemTimes.merge(item, 1, Integer::sum);
            break;
        }
        if (!hasIngredient) {
            canMake[0] = false;
            itemTimes.clear();
            invIngredient.clear();
            return false;
        }
        return true;
    }
}

