/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.v1.fr;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.init.registry.tlm.RegisterData;
import com.github.wallev.farmsoulkitchen.task.TaskInfo;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.farmsoulkitchen.task.cook.v1.common.TaskFdPot;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import umpaz.farmersrespite.common.block.entity.KettleBlockEntity;
import umpaz.farmersrespite.common.crafting.KettlePouringRecipe;
import umpaz.farmersrespite.common.crafting.KettleRecipe;
import umpaz.farmersrespite.common.registry.FRItems;
import umpaz.farmersrespite.common.registry.FRRecipeTypes;

public class TaskFrKettle
extends TaskFdPot<KettleBlockEntity, KettleRecipe> {
    private static final Map<KettleRecipe, KettleRecipeWrapper> KETTLE_UNION_RECIPES = new HashMap<KettleRecipe, KettleRecipeWrapper>();

    @Override
    public boolean shouldMoveTo(ServerLevel level, EntityMaid maid, KettleBlockEntity be, MaidRecipesManager<KettleRecipe> manager) {
        ItemStackHandler itemStackHandler = this.getItemStackHandler(be);
        return super.shouldMoveTo(level, maid, be, manager);
    }

    @Override
    public List<KettleRecipe> getRecipes(Level level) {
        if (KETTLE_UNION_RECIPES.isEmpty()) {
            List pours = level.m_7465_().m_44013_((RecipeType)FRRecipeTypes.KETTLE_POURING.get());
            List recipes = super.getRecipes(level);
            int i = 0;
            for (KettleRecipe recipe : recipes) {
                KETTLE_UNION_RECIPES.put(recipe, new KettleRecipeWrapper(((KettlePouringRecipe)pours.get(i)).getOutput(), ((KettlePouringRecipe)pours.get(i)).getContainer(), ((KettlePouringRecipe)pours.get(i)).getContainer()));
                ++i;
            }
        }
        return KETTLE_UNION_RECIPES.keySet().stream().toList();
    }

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof KettleBlockEntity;
    }

    @Override
    public RecipeType<KettleRecipe> getRecipeType() {
        return (RecipeType)FRRecipeTypes.BREWING.get();
    }

    @Override
    public int getOutputSlot() {
        return 4;
    }

    @Override
    public int getInputSize() {
        return 2;
    }

    @Override
    public ItemStackHandler getBeInv(KettleBlockEntity kettleBlockEntity) {
        return kettleBlockEntity.getInventory();
    }

    public ResourceLocation getUid() {
        return TaskInfo.FR_KETTLE.uid;
    }

    public ItemStack getIcon() {
        return ((Item)FRItems.KETTLE.get()).m_7968_();
    }

    @Override
    public int getMealStackSlot() {
        return 3;
    }

    @Override
    public int getContainerStackSlot() {
        return 2;
    }

    @Override
    @NotNull
    public ItemStack getBeInvMealStack(KettleBlockEntity be, ItemStackHandler inventory) {
        return be.getFluidTank().isEmpty() ? ItemStack.f_41583_ : Items.f_42590_.m_7968_();
    }

    @Override
    public MaidRecipesManager<KettleRecipe> getRecipesManager(EntityMaid maid) {
        return new MaidRecipesManager<KettleRecipe>(maid, (ICookTask)this, false){

            @Override
            protected boolean extraStartRecipe(KettleRecipe recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
                return TaskFrKettle.this.tExtraStartRecipe(recipe, available, single, canMake, itemTimes, invIngredient);
            }

            @Override
            protected boolean extraEndRecipe(KettleRecipe recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
                return super.extraEndRecipe(recipe, available, single, canMake, itemTimes, invIngredient);
            }

            @Override
            protected Pair<List<Integer>, List<Item>> getAmountIngredient(KettleRecipe recipe, Map<Item, Integer> available) {
                return super.getAmountIngredient(recipe, available);
            }
        };
    }

    protected boolean tExtraStartRecipe(KettleRecipe recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
        ItemStack extraItem = TaskFrKettle.KETTLE_UNION_RECIPES.get((Object)recipe).container;
        boolean hasIngredient = false;
        for (Item item : available.keySet()) {
            ItemStack stack = item.m_7968_();
            if (!stack.m_150930_(extraItem.m_41720_())) continue;
            invIngredient.add(item);
            hasIngredient = true;
            if (stack.m_41741_() == 1) {
                single[0] = true;
                itemTimes.put(item, 1);
                break;
            }
            itemTimes.merge(item, 1, Integer::sum);
            break;
        }
        if (!hasIngredient) {
            canMake[0] = false;
            itemTimes.clear();
            invIngredient.clear();
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getFoodContainer(KettleBlockEntity kettle) {
        int mealStackSlot = this.getMealStackSlot();
        ItemStackHandler itemStackHandler = this.getItemStackHandler(kettle);
        ItemStack mealStack = itemStackHandler.getStackInSlot(mealStackSlot);
        Optional pouringRecipe = kettle.getPouringRecipe(mealStack.m_41720_(), kettle.getFluidTank().getFluid());
        if (pouringRecipe.isPresent()) {
            return ((KettlePouringRecipe)pouringRecipe.get()).getContainer();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void insertInputsStack(ItemStackHandler beInv, IItemHandlerModifiable maidInv, KettleBlockEntity be, Pair<List<Integer>, List<List<ItemStack>>> ingredientPair) {
        List ingredients;
        List amounts = (List)ingredientPair.getFirst();
        if (this.hasEnoughIngredient(amounts, ingredients = (List)ingredientPair.getSecond())) {
            int i = this.getInputStartSlot() + 1;
            int j = 0;
            while (i < ingredients.size() + this.getInputStartSlot()) {
                this.insertAndShrink(beInv, (Integer)amounts.get(j), ingredients, j, i);
                ++i;
                ++j;
            }
            be.m_6596_();
        }
        KettleBlockEntity kettleBlockEntity = be;
        List itemStacks = (List)ingredients.get(0);
        for (ItemStack itemStack : itemStacks) {
        }
        this.updateIngredient(ingredientPair);
    }

    @Override
    public ItemStackHandler getItemStackHandler(KettleBlockEntity be) {
        return be.getInventory();
    }

    @Override
    public boolean isHeated(KettleBlockEntity be) {
        return be.isHeated();
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.FR_KETTLE;
    }

    @Override
    public ItemStack getResultItem(Recipe<?> recipe, RegistryAccess pRegistryAccess) {
        return TaskFrKettle.KETTLE_UNION_RECIPES.get((Object)((KettleRecipe)recipe)).output;
    }

    public static class KettleRecipeWrapper {
        public final ItemStack output;
        public final ItemStack container;
        public final ItemStack fluidStack;

        public KettleRecipeWrapper(ItemStack output, ItemStack container, ItemStack fluidStack) {
            this.output = output;
            this.container = container;
            this.fluidStack = fluidStack;
        }
    }
}

