/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.v1.kitchencarrot;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.IHandlerCookBe;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.IItemHandlerCook;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.init.registry.tlm.RegisterData;
import com.github.wallev.farmsoulkitchen.mixin.kitchkarrot.AirCompressorBlockEntityAccessor;
import com.github.wallev.farmsoulkitchen.task.TaskInfo;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.mojang.datafixers.util.Pair;
import io.github.tt432.kitchenkarrot.blockentity.AirCompressorBlockEntity;
import io.github.tt432.kitchenkarrot.recipes.recipe.AirCompressorRecipe;
import io.github.tt432.kitchenkarrot.registries.ModBlocks;
import io.github.tt432.kitchenkarrot.registries.RecipeTypes;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TaskAirCompressor
implements ICookTask<AirCompressorBlockEntity, AirCompressorRecipe>,
IHandlerCookBe<AirCompressorBlockEntity>,
IItemHandlerCook<AirCompressorBlockEntity, AirCompressorRecipe> {
    private static void replenishEnergy(EntityMaid maid, AirCompressorBlockEntity brewBe, CombinedInvWrapper maidInv) {
        int energyItemSlot = ItemsUtil.findStackSlot((IItemHandler)maidInv, stack -> stack.m_150930_(Items.f_42451_));
        if (energyItemSlot > -1) {
            ItemStack stackInSlot = maidInv.getStackInSlot(energyItemSlot);
            ItemHandlerHelper.insertItemStacked((IItemHandler)brewBe.getInput2(), (ItemStack)stackInSlot.m_41620_(1), (boolean)false);
        }
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.KC_AIR_COMPRESSOR;
    }

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof AirCompressorBlockEntity;
    }

    @Override
    public RecipeType<AirCompressorRecipe> getRecipeType() {
        return (RecipeType)RecipeTypes.AIR_COMPRESSOR.get();
    }

    @Override
    public boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid maid, AirCompressorBlockEntity blockEntity, MaidRecipesManager<AirCompressorRecipe> recManager) {
        boolean findChargeItem;
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        AirCompressorBlockEntityAccessor accessor = (AirCompressorBlockEntityAccessor)blockEntity;
        if (!blockEntity.getOutput().getStackInSlot(0).m_41619_()) {
            return true;
        }
        boolean bl = findChargeItem = ItemsUtil.findStackSlot((IItemHandler)maidInv, stack -> stack.m_150930_(Items.f_42451_)) > -1;
        if (!accessor.callIsStarted() && !recManager.getRecipesIngredients().isEmpty()) {
            return accessor.callHasEnergy() || findChargeItem;
        }
        if (accessor.callGetRecipeFromItems() != null && !accessor.callHasEnergy() && findChargeItem) {
            return true;
        }
        return !accessor.callIsStarted() && this.hasInput(blockEntity.getInput1());
    }

    @Override
    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, AirCompressorBlockEntity blockEntity, MaidRecipesManager<AirCompressorRecipe> recManager) {
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        AirCompressorBlockEntityAccessor accessor = (AirCompressorBlockEntityAccessor)blockEntity;
        if (!accessor.callHasEnergy()) {
            TaskAirCompressor.replenishEnergy(maid, blockEntity, maidInv);
        }
        if (!blockEntity.getOutput().getStackInSlot(0).m_41619_()) {
            this.extractOutputStack(blockEntity.getOutput(), recManager.getOutputInv(), (BlockEntity)blockEntity);
        }
        this.pickupAction(maid);
        if (!accessor.callIsStarted() && this.hasInput(blockEntity.getInput1())) {
            this.extractInputsStack(blockEntity.getInput1(), recManager.getInputInv(), (BlockEntity)blockEntity);
        }
        if (!accessor.callIsStarted() && accessor.callHasEnergy() && !recManager.getRecipesIngredients().isEmpty()) {
            Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = recManager.getRecipeIngredient();
            if (((List)recipeIngredient.getFirst()).isEmpty()) {
                return;
            }
            this.insertInputsStack(blockEntity.getInput1(), (IItemHandlerModifiable)maidInv, (BlockEntity)blockEntity, recipeIngredient);
        }
        this.pickupAction(maid);
        recManager.getCookInv().syncInv();
    }

    public ResourceLocation getUid() {
        return TaskInfo.KK_AIR_COMPRESSOR.uid;
    }

    public ItemStack getIcon() {
        return ((Block)ModBlocks.AIR_COMPRESSOR.get()).m_5456_().m_7968_();
    }

    @Override
    public ItemStackHandler getItemStackHandler(AirCompressorBlockEntity airCompressorBlockEntity) {
        return airCompressorBlockEntity.getInput1();
    }

    @Override
    public int getOutputSlot() {
        return 0;
    }

    @Override
    public int getInputSize() {
        return 5;
    }

    @Override
    public ItemStackHandler getBeInv(AirCompressorBlockEntity airCompressorBlockEntity) {
        return airCompressorBlockEntity.getInput1();
    }

    @Override
    public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        AirCompressorRecipe airCompressorRecipe = (AirCompressorRecipe)recipe;
        NonNullList ingredient = airCompressorRecipe.getIngredient();
        Ingredient container = airCompressorRecipe.getContainer();
        if (container != null) {
            NonNullList ingredients = NonNullList.m_122779_();
            ingredients.addAll((Collection)ingredient);
            ingredients.add((Object)container);
            return ingredients;
        }
        return ingredient;
    }
}

