/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.v1.kitchencarrot;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.IHandlerCookBe;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.IItemHandlerCook;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.entity.passive.IAddonMaid;
import com.github.wallev.farmsoulkitchen.init.registry.tlm.RegisterData;
import com.github.wallev.farmsoulkitchen.task.TaskInfo;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.farmsoulkitchen.util.FakePlayerUtil;
import com.mojang.datafixers.util.Pair;
import io.github.tt432.kitchenkarrot.blockentity.BrewingBarrelBlockEntity;
import io.github.tt432.kitchenkarrot.capability.KKItemStackHandler;
import io.github.tt432.kitchenkarrot.recipes.recipe.BrewingBarrelRecipe;
import io.github.tt432.kitchenkarrot.registries.ModBlocks;
import io.github.tt432.kitchenkarrot.registries.ModItems;
import io.github.tt432.kitchenkarrot.registries.RecipeTypes;
import io.github.tt432.kitchenkarrot.util.ItemHandlerUtils;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TaskKkBrewingBarrel
implements ICookTask<BrewingBarrelBlockEntity, BrewingBarrelRecipe>,
IHandlerCookBe<BrewingBarrelBlockEntity>,
IItemHandlerCook<BrewingBarrelBlockEntity, BrewingBarrelRecipe> {
    public static final Map<Item, Integer> FLUID_WATER = Map.of(Items.f_42447_, 1, (Item)ModItems.WATER.get(), 4);

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof BrewingBarrelBlockEntity;
    }

    @Override
    public RecipeType<BrewingBarrelRecipe> getRecipeType() {
        return (RecipeType)RecipeTypes.BREWING_BARREL.get();
    }

    @Override
    public boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid maid, BrewingBarrelBlockEntity brewBe, MaidRecipesManager<BrewingBarrelRecipe> recManager) {
        boolean findFluidItem;
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        if (!this.getResultHandler(brewBe).getStackInSlot(this.getOutputSlot()).m_41619_()) {
            return true;
        }
        boolean bl = findFluidItem = ItemsUtil.findStackSlot((IItemHandler)maidInv, stack -> FLUID_WATER.containsKey(stack.m_41720_()) && stack.m_41613_() >= FLUID_WATER.get(stack.m_41720_())) > -1;
        if (!brewBe.isStarted() && !recManager.getRecipesIngredients().isEmpty()) {
            return brewBe.hasEnoughWater() || findFluidItem;
        }
        if (TaskKkBrewingBarrel.hasRecipe(brewBe) && !brewBe.hasEnoughWater() && findFluidItem) {
            return true;
        }
        return !brewBe.isStarted() && this.hasInput((ItemStackHandler)this.getInputHandler(brewBe));
    }

    private static boolean hasRecipe(BrewingBarrelBlockEntity brewBe) {
        List inputList = ItemHandlerUtils.toList((IItemHandler[])new IItemHandler[]{brewBe.input});
        return brewBe.m_58904_().m_7465_().m_44013_((RecipeType)RecipeTypes.BREWING_BARREL.get()).stream().anyMatch(r -> r.matches(inputList));
    }

    @Override
    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, BrewingBarrelBlockEntity brewBe, MaidRecipesManager<BrewingBarrelRecipe> recManager) {
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        if (!brewBe.hasEnoughWater()) {
            TaskKkBrewingBarrel.replenishWater(maid, brewBe, maidInv);
        }
        if (!this.getResultHandler(brewBe).getStackInSlot(this.getOutputSlot()).m_41619_()) {
            this.extractOutputStack((ItemStackHandler)this.getResultHandler(brewBe), recManager.getOutputInv(), (BlockEntity)brewBe);
        }
        this.pickupAction(maid);
        if (!brewBe.isStarted() && this.hasInput((ItemStackHandler)this.getInputHandler(brewBe))) {
            this.extractInputsStack((ItemStackHandler)this.getInputHandler(brewBe), recManager.getInputInv(), (BlockEntity)brewBe);
        }
        if (!brewBe.isStarted() && brewBe.hasEnoughWater() && !recManager.getRecipesIngredients().isEmpty()) {
            Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = recManager.getRecipeIngredient();
            if (((List)recipeIngredient.getFirst()).isEmpty()) {
                return;
            }
            this.insertInputsStack((ItemStackHandler)this.getInputHandler(brewBe), (IItemHandlerModifiable)maidInv, (BlockEntity)brewBe, recipeIngredient);
        }
        this.pickupAction(maid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void replenishWater(EntityMaid maid, BrewingBarrelBlockEntity brewBe, CombinedInvWrapper maidInv) {
        int fluidItemSlot = ItemsUtil.findStackSlot((IItemHandler)maidInv, stack -> FLUID_WATER.containsKey(stack.m_41720_()) && stack.m_41613_() >= FLUID_WATER.get(stack.m_41720_()));
        if (fluidItemSlot <= -1) return;
        ItemStack waterStack = maid.getAvailableInv(true).getStackInSlot(fluidItemSlot);
        WeakReference<FakePlayer> fakePlayer$tlma = ((IAddonMaid)maid).getFakePlayer$tlma();
        FakePlayer fakePlayer = (FakePlayer)fakePlayer$tlma.get();
        if (fakePlayer == null) return;
        int time = FLUID_WATER.getOrDefault(waterStack.m_41720_(), 0);
        for (int i = 0; i < time; ++i) {
            fakePlayer.m_21008_(InteractionHand.MAIN_HAND, waterStack.m_41620_(1));
            try {
                InteractionResult interactionResult = FakePlayerUtil.interactUseOnBlock(fakePlayer$tlma, maid.m_9236_(), brewBe.m_58899_(), InteractionHand.MAIN_HAND, null);
                if (interactionResult != InteractionResult.PASS) {
                    ItemStack itemInHand = fakePlayer.m_21120_(InteractionHand.MAIN_HAND);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)maid.getAvailableInv(true), (ItemStack)itemInHand.m_41777_(), (boolean)false);
                    fakePlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                } else {
                    fakePlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
                if (interactionResult != InteractionResult.PASS) continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public KKItemStackHandler getInputHandler(BrewingBarrelBlockEntity brewBe) {
        return brewBe.input;
    }

    public KKItemStackHandler getResultHandler(BrewingBarrelBlockEntity brewBe) {
        return (KKItemStackHandler)brewBe.result();
    }

    public ResourceLocation getUid() {
        return TaskInfo.KK_BREW_BARREL.uid;
    }

    public ItemStack getIcon() {
        return ((Block)ModBlocks.BREWING_BARREL.get()).m_5456_().m_7968_();
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.KC_BREW_BARREL;
    }

    @Override
    public ItemStackHandler getItemStackHandler(BrewingBarrelBlockEntity brewingBarrelBlockEntity) {
        return brewingBarrelBlockEntity.input;
    }

    @Override
    public int getOutputSlot() {
        return 0;
    }

    @Override
    public int getInputSize() {
        return 6;
    }

    @Override
    public ItemStackHandler getBeInv(BrewingBarrelBlockEntity brewingBarrelBlockEntity) {
        return brewingBarrelBlockEntity.input;
    }

    @Override
    public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        return ((BrewingBarrelRecipe)recipe).getIngredient();
    }
}

