/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.farm;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.api.TaskBookEntryType;
import com.github.wallev.farmsoulkitchen.api.task.IAddonFarmTask;
import com.github.wallev.farmsoulkitchen.api.task.IFakePlayerTask;
import com.github.wallev.farmsoulkitchen.api.task.v1.farm.ICompatFarm;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.BerryData;
import com.github.wallev.farmsoulkitchen.init.registry.tlm.RegisterData;
import com.github.wallev.farmsoulkitchen.inventory.container.maid.BerryFarmConfigContainer;
import com.github.wallev.farmsoulkitchen.task.TaskInfo;
import com.github.wallev.farmsoulkitchen.task.ai.MaidCompatFarmMoveTask;
import com.github.wallev.farmsoulkitchen.task.ai.MaidCompatFarmPlantTask;
import com.github.wallev.farmsoulkitchen.task.farm.handler.v1.IFarmHandlerManager;
import com.github.wallev.farmsoulkitchen.task.farm.handler.v1.berry.BerryHandler;
import com.github.wallev.farmsoulkitchen.task.farm.handler.v1.berry.BerryHandlerManager;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;

public class TaskBerryFarm
implements ICompatFarm<BerryHandler, BerryData>,
IFakePlayerTask,
IAddonFarmTask {
    @Override
    public IFarmHandlerManager<BerryHandler>[] getManagerHandlerValues() {
        return BerryHandlerManager.values();
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, BerryHandler handler) {
        return handler != null && handler.canHarvest(maid, cropPos, cropState);
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, BerryHandler handler) {
        this.maidRightClick(maid, cropPos);
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Lists.newArrayList();
        }
        MaidCompatFarmMoveTask<BerryHandler> maidFarmMoveTask = new MaidCompatFarmMoveTask<BerryHandler>(maid, (ICompatFarm)this, 0.6f){

            public boolean checkPathReach(EntityMaid maid, BlockPos pos) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (!maid.canPathReach(pos.m_7918_(x, 0, z))) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        MaidCompatFarmPlantTask<BerryHandler> maidFarmPlantTask = new MaidCompatFarmPlantTask<BerryHandler>(maid, this, (BerryHandler)maidFarmMoveTask.getCompatFarmHandler());
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)maidFarmMoveTask), Pair.of((Object)6, maidFarmPlantTask)});
    }

    @Override
    public double getCloseEnoughDist() {
        return 2.0;
    }

    @Override
    public BerryData getDefaultData() {
        return new BerryData();
    }

    public ResourceLocation getUid() {
        return TaskInfo.BERRY_FARM.uid;
    }

    public ItemStack getIcon() {
        return Items.f_42780_.m_7968_();
    }

    public boolean isEnable(EntityMaid maid) {
        return true;
    }

    @Override
    public TaskBookEntryType getBookEntryType() {
        return TaskBookEntryType.BERRY_FARM;
    }

    public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Berry Farm Config Container");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory playerInventory, Player player) {
                return new BerryFarmConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    @Override
    public TaskDataKey<BerryData> getCookDataKey() {
        return RegisterData.BERRY_FARM;
    }
}

