/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.other;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFeedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.github.wallev.farmsoulkitchen.api.ILittleMaidTask;
import com.github.wallev.farmsoulkitchen.api.task.IDrinkTask;
import com.github.wallev.farmsoulkitchen.task.TaskInfo;
import com.github.wallev.farmsoulkitchen.task.ai.MaidFeedAndDrinkOwnerTask;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.capability.ModCapabilities;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TaskFeedAndDrinkOwner
implements ILittleMaidTask,
IFeedTask,
IDrinkTask {
    public ItemStack getIcon() {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
    }

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound((EntityMaid)maid, (SoundEvent)((SoundEvent)InitSounds.MAID_FEED.get()), (float)0.3f);
    }

    public ResourceLocation getUid() {
        return TaskInfo.FEED_AND_DRINK_OWNER.uid;
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)new MaidFeedAndDrinkOwnerTask(this, this, 2, 0.6f)))});
    }

    @Override
    public boolean isDrink(ItemStack stack, Player owner) {
        return ThirstHelper.isDrink((ItemStack)stack);
    }

    @Override
    public IDrinkTask.Priority getDrinkPriority(ItemStack stack, Player owner) {
        IThirst iThirst;
        if (ThirstHelper.itemRestoresThirst((ItemStack)stack) && ThirstHelper.isDrink((ItemStack)stack) && (iThirst = (IThirst)owner.getCapability(ModCapabilities.PLAYER_THIRST).orElse(null)) != null) {
            int hunger;
            int heal = ThirstHelper.getThirst((ItemStack)stack);
            if (heal == (hunger = 20 - iThirst.getThirst())) {
                return IDrinkTask.Priority.HIGH;
            }
            if (heal > hunger) {
                return IDrinkTask.Priority.LOWEST;
            }
            return IDrinkTask.Priority.LOW;
        }
        return IDrinkTask.Priority.NONE;
    }

    @Override
    public ItemStack drink(ItemStack stack, Player owner) {
        if (stack.m_41780_() == UseAnim.DRINK) {
            owner.f_19853_.m_6269_(null, (Entity)owner, stack.m_41615_(), SoundSource.NEUTRAL, 0.5f, owner.f_19853_.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
        AtomicBoolean canDrink = new AtomicBoolean(false);
        owner.getCapability(ModCapabilities.PLAYER_THIRST).ifPresent(cap -> {
            if (WaterPurity.givePurityEffects((Player)owner, (ItemStack)stack)) {
                cap.drink(owner, ThirstHelper.getThirst((ItemStack)stack), ThirstHelper.getQuenched((ItemStack)stack));
                canDrink.set(true);
            }
        });
        if (canDrink.get()) {
            return stack.m_41720_().m_5922_(stack, owner.m_9236_(), (LivingEntity)owner);
        }
        return stack;
    }

    public boolean isFood(ItemStack stack, Player owner) {
        FoodProperties food;
        if (stack.m_41720_() == Items.f_42455_) {
            for (MobEffectInstance effect : owner.m_21220_()) {
                if (!this.isHarmfulEffect(effect) || effect.m_19557_() <= 60 || !effect.isCurativeItem(stack)) continue;
                return true;
            }
            return false;
        }
        if (stack.m_41720_().getFoodProperties(stack, (LivingEntity)owner) != null && (food = stack.m_41720_().getFoodProperties(stack, (LivingEntity)owner)) != null && food.m_38744_() > 0) {
            return food.m_38749_().isEmpty() || food.m_38749_().stream().noneMatch(pair -> this.isHarmfulEffect((MobEffectInstance)pair.getFirst()));
        }
        return false;
    }

    public IFeedTask.Priority getPriority(ItemStack stack, Player owner) {
        if (stack.m_41720_() == Items.f_42455_) {
            return IFeedTask.Priority.HIGH;
        }
        if (stack.m_41720_() == Items.f_42436_) {
            if (owner.m_21223_() * 2.0f < owner.m_21233_()) {
                return IFeedTask.Priority.HIGH;
            }
            return IFeedTask.Priority.LOWEST;
        }
        if (stack.m_41720_().getFoodProperties(stack, (LivingEntity)owner) != null) {
            int hunger;
            FoodProperties food = stack.m_41720_().getFoodProperties(stack, (LivingEntity)owner);
            int heal = 0;
            if (food != null) {
                heal = food.m_38744_();
            }
            if (heal == (hunger = 20 - owner.m_36324_().m_38702_())) {
                return IFeedTask.Priority.HIGH;
            }
            if (heal > hunger) {
                return IFeedTask.Priority.LOWEST;
            }
            return IFeedTask.Priority.LOW;
        }
        return IFeedTask.Priority.NONE;
    }

    public ItemStack feed(ItemStack stack, Player owner) {
        if (stack.m_41780_() == UseAnim.DRINK) {
            owner.f_19853_.m_6269_(null, (Entity)owner, stack.m_41615_(), SoundSource.NEUTRAL, 0.5f, owner.f_19853_.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
        return stack.m_41720_().m_5922_(stack, owner.m_9236_(), (LivingEntity)owner);
    }

    private boolean isHarmfulEffect(MobEffectInstance effect) {
        return effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL;
    }
}

