/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.other;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.DefaultMaidTaskConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.github.wallev.farmsoulkitchen.api.ILittleMaidTask;
import com.github.wallev.farmsoulkitchen.config.subconfig.TaskConfig;
import com.github.wallev.farmsoulkitchen.task.TaskInfo;
import com.github.wallev.farmsoulkitchen.task.ai.MaidFeedAnimalTaskT;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandler;

public class TaskFeedAnimalT
implements IAttackTask,
ILittleMaidTask {
    private static final int MAX_STOP_ATTACK_DISTANCE = 8;

    public ResourceLocation getUid() {
        return TaskInfo.FEED_ANIMAL_T.uid;
    }

    public ItemStack getIcon() {
        return Items.f_42405_.m_7968_();
    }

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound((EntityMaid)maid, (SoundEvent)((SoundEvent)InitSounds.MAID_FEED_ANIMAL.get()), (float)0.5f);
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::hasAssaultWeapon, this::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.hasAssaultWeapon(maid) || this.farAway((LivingEntity)target, maid));
        BehaviorControl moveToTargetTask = SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)0.6f);
        OneShot attackTargetTask = MeleeAttack.m_257733_((int)20);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)new MaidFeedAnimalTaskT(0.6f, (Integer)TaskConfig.FEED_SINGLE_ANIMAL_MAX_NUMBER.get()))), Pair.of((Object)6, (Object)supplementedTask), Pair.of((Object)6, (Object)findTargetTask), Pair.of((Object)6, (Object)moveToTargetTask), Pair.of((Object)6, (Object)attackTargetTask)});
    }

    private Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        List<LivingEntity> list = this.getEntities(maid).m_186128_(e -> maid.m_21444_(e.m_20183_())).filter(livingEntity -> livingEntity instanceof Animal).filter(Entity::m_6084_).toList();
        HashMap<EntityType, List> resourceLocationListHashMap = new HashMap<EntityType, List>();
        for (LivingEntity livingEntity2 : list) {
            resourceLocationListHashMap.computeIfAbsent(livingEntity2.m_6095_(), k -> Lists.newArrayList()).add((Animal)livingEntity2);
        }
        for (List value : resourceLocationListHashMap.values()) {
            if (value.size() < (Integer)TaskConfig.FEED_SINGLE_ANIMAL_MAX_NUMBER.get() - 2) continue;
            return value.stream().filter(e -> maid.m_21444_(e.m_20183_())).filter(e -> !e.m_6162_()).filter(e -> ItemsUtil.isStackIn((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((Animal)e).m_6898_(arg_0))).filter(arg_0 -> ((EntityMaid)maid).canPathReach(arg_0)).findFirst();
        }
        return Optional.empty();
    }

    public boolean canAttack(EntityMaid maid, LivingEntity target) {
        return true;
    }

    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"can_feed", (Object)Predicates.alwaysTrue()), Pair.of((Object)"assault_weapon", this::hasAssaultWeapon)});
    }

    public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Task Config Container");
            }

            public AbstractMaidContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new DefaultMaidTaskConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
    }

    private boolean hasAssaultWeapon(EntityMaid maid) {
        return maid.m_21205_().m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_);
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > 8.0f;
    }

    @Override
    public String getBookEntry() {
        return "feed_animal_t";
    }
}

