/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public final class MaidDataUtil {
    public static final EntityDataAccessor<Integer> START_Y_OFFSET = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public static void setStartYOffset(EntityMaid maid, int offset) {
        maid.m_20088_().m_135381_(START_Y_OFFSET, (Object)offset);
    }

    public static ItemStack getMaidSlotStack(EntityMaid maid, Integer slot) {
        return maid.getAvailableInv(true).getStackInSlot(slot.intValue());
    }

    public static Integer getStartYOffset(EntityMaid maid) {
        return (Integer)maid.m_20088_().m_135370_(START_Y_OFFSET);
    }

    public static Integer getMaidInventoryItemStackSlot(EntityMaid maid, Predicate<ItemStack> predicate) {
        HashMap map = new HashMap();
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack slotStack = availableInv.getStackInSlot(i);
            if (slotStack.m_41619_() || !predicate.test(slotStack)) continue;
            return i;
        }
        return -1;
    }

    public static Integer findMaidInventoryItemStack(EntityMaid maid, Predicate<ItemStack> predicate) {
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack slotStack = availableInv.getStackInSlot(i);
            if (slotStack.m_41619_() || !predicate.test(slotStack)) continue;
            return i;
        }
        return -1;
    }

    public static Integer findMaidInventoryItemStack(CombinedInvWrapper availableInv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack slotStack = availableInv.getStackInSlot(i);
            if (slotStack.m_41619_() || !predicate.test(slotStack)) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack findMaidInventoryStack(CombinedInvWrapper availableInv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack slotStack = availableInv.getStackInSlot(i);
            if (slotStack.m_41619_() || !predicate.test(slotStack)) continue;
            return slotStack;
        }
        return ItemStack.f_41583_;
    }

    public static void consumerMaidInv(CombinedInvWrapper availableInv, Consumer<ItemStack> printConsumer) {
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack slotStack = availableInv.getStackInSlot(i);
            if (slotStack.m_41619_()) continue;
            printConsumer.accept(slotStack);
        }
    }

    public static void consumerPairMaidInv(CombinedInvWrapper availableInv, Consumer<Pair<ItemStack, Integer>> printConsumer) {
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack slotStack = availableInv.getStackInSlot(i);
            if (slotStack.m_41619_()) continue;
            printConsumer.accept((Pair<ItemStack, Integer>)new Pair((Object)slotStack, (Object)i));
        }
    }

    public static Integer findInventoryItemStack(IItemHandler chestInv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < chestInv.getSlots(); ++i) {
            ItemStack slotStack = chestInv.getStackInSlot(i);
            if (slotStack.m_41619_() || !predicate.test(slotStack)) continue;
            return i;
        }
        return -1;
    }

    public static Map<Integer, ItemStack> getMaidInventoryItemStacks(EntityMaid maid) {
        HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack slotStack = availableInv.getStackInSlot(i);
            if (slotStack.m_41619_()) continue;
            map.put(i, slotStack);
        }
        return map;
    }
}

