/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.init.touhoulittlemaid;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.wallev.maidsoulkitchen.api.task.IMaidsoulKitchenTask;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.github.wallev.maidsoulkitchen.task.cook.common.task.CookTaskManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public final class TaskRegister {
    private static final List<LegacyTaskInfo> LEGACY_TASK = new ArrayList<LegacyTaskInfo>();

    private TaskRegister() {
    }

    public static void addLegacyTask(Supplier<ResourceLocation> uid, Supplier<Mods> bindMod, Supplier<Boolean> bindConfig, Supplier<IMaidsoulKitchenTask> task, String ... mixinClz) {
        TaskRegister.addLegacyTask(uid, bindMod, bindConfig, task, Lists.newArrayList((Object[])mixinClz));
    }

    public static void addLegacyTask(Supplier<ResourceLocation> uid, Supplier<Mods> bindMod, Supplier<Boolean> bindConfig, Supplier<IMaidsoulKitchenTask> task, List<String> mixinClz) {
        LEGACY_TASK.add(new LegacyTaskInfo(uid, bindMod, bindConfig, task, mixinClz));
    }

    public static void addLegacyCookTask(Supplier<ResourceLocation> uid, Supplier<Mods> bindMod, Supplier<Boolean> bindConfig, Supplier<ICookTask<?, ?>> task, String ... mixinClz) {
        CookTaskManager.addLegacyTask(uid, bindMod, bindConfig, task, mixinClz);
    }

    public static void addLegacyCookTask(Supplier<ResourceLocation> uid, Supplier<Mods> bindMod, Supplier<Boolean> bindConfig, Supplier<ICookTask<?, ?>> task, List<String> mixinClz) {
        CookTaskManager.addLegacyTask(uid, bindMod, bindConfig, task, mixinClz);
    }

    private static void registerLegacyCompat() {
        for (LegacyTaskInfo legacy : LEGACY_TASK) {
            if (!legacy.bindModLoad()) continue;
            ResourceLocation taskUid = legacy.getUid();
            IMaidsoulKitchenTask.putTask(taskUid, () -> legacy.bindConfigLoad() && IMaidsoulKitchenTask.TaskMixinMap.isApplyMixin(taskUid), legacy.bindTask());
            if (legacy.mixinClz().isEmpty()) continue;
            IMaidsoulKitchenTask.TaskMixinMap.putList(taskUid, legacy.mixinClz());
        }
    }

    public static void init(TaskManager taskManager) {
        TaskRegister.registerLegacyCompat();
        IMaidsoulKitchenTask.getTasks().forEach((key, value) -> {
            if (value.getContidion().get().booleanValue()) {
                IMaidsoulKitchenTask maidsoulKitchenTask = value.getTask().get();
                taskManager.add((IMaidTask)maidsoulKitchenTask);
            }
        });
        CookTaskManager.init();
    }

    public record LegacyTaskInfo(Supplier<ResourceLocation> uid, Supplier<Mods> bindMod, Supplier<Boolean> bindConfig, Supplier<IMaidsoulKitchenTask> bindTask, List<String> mixinClz) {
        public LegacyTaskInfo(Supplier<ResourceLocation> uid, Supplier<Mods> bindMod, Supplier<Boolean> bindConfig, Supplier<IMaidsoulKitchenTask> bindTask, String ... mixinClz) {
            this(uid, bindMod, bindConfig, bindTask, Lists.newArrayList((Object[])mixinClz));
        }

        public ResourceLocation getUid() {
            return this.uid.get();
        }

        public boolean bindConfigLoad() {
            return this.bindConfig.get();
        }

        public boolean bindModLoad() {
            return this.bindMod.get().versionLoad();
        }
    }
}

