/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.ModClazzChecker;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ITaskInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.TaskMixinAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.ClassAnalyzerTool;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.TaskClazzInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.VerifyExistence;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager.BaseClazzCheckManager;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class ClassAnalyzerManager {
    public static void writeModTaskClazz(Path rootOutputFolder, BaseClazzCheckManager<?, ?> checkManager) throws Exception {
        Type taskClazzAnnotationType = checkManager.getTaskClazzAnnotationType();
        Type taskMixinClazzAnnotationType = checkManager.getTaskClazzMixinAnnotationType();
        List allScanData = ModList.get().getAllScanData();
        ClassMap clazzMap = new ClassMap();
        for (ModFileScanData scanData : allScanData) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                Object taskValue;
                Type annotationedType = data.annotationType();
                String memberName = data.memberName();
                if (Objects.equals(annotationedType, taskClazzAnnotationType)) {
                    taskValue = data.annotationData().get("value");
                    if (taskValue == null) {
                        throw new RuntimeException("Please specify the task category: " + data.memberName());
                    }
                    Object task = checkManager.taskInfoByKey(ClassAnalyzerManager.getEnumHolderValue(data, "value"));
                    clazzMap.addClazz((ITaskInfo<?>)task, Class.forName(memberName));
                }
                if (!Objects.equals(annotationedType, taskMixinClazzAnnotationType) || !data.memberName().startsWith(checkManager.getMixinPackage())) continue;
                taskValue = data.annotationData().get("value");
                if (taskValue == null) {
                    throw new RuntimeException("Please specify the task category: " + data.memberName());
                }
                List<ModAnnotation.EnumHolder> tasks = ClassAnalyzerManager.getEnumHolders(data, "value");
                for (ModAnnotation.EnumHolder taskVal : tasks) {
                    Object task = checkManager.taskInfoByKey(taskVal.getValue());
                    clazzMap.addTaskMixin((ITaskInfo<?>)task, memberName);
                }
            }
        }
        ClassAnalyzerTool.analyzerAndGenerateFile(rootOutputFolder, clazzMap, checkManager);
    }

    public static TaskClazzInfo readModTaskClazzFromFile(BaseClazzCheckManager<?, ?> checkManager) {
        try {
            Path resource = LoadingModList.get().getModFileById(checkManager.getModId()).getFile().findResource(new String[]{checkManager.getFileName()});
            String json = Files.readString(resource);
            JsonObject jsonData = JsonParser.parseString((String)json).getAsJsonObject();
            return (TaskClazzInfo)TaskClazzInfo.CODEC.apply(checkManager.getModsCodecO()).parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonData).resultOrPartial(error -> ModClazzChecker.LOGGER.error("read modtaskclazz error\uff1a{}, from file: {}", error, (Object)resource)).orElseThrow();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TaskMixinAnalyzer.ModTaskMixinMap readModTaskMixinClazzFromFile(BaseClazzCheckManager<?, ?> checkManager) {
        try {
            Path resource = LoadingModList.get().getModFileById(checkManager.getModId()).getFile().findResource(new String[]{checkManager.getFileName()});
            String json = Files.readString(resource);
            JsonObject jsonData = JsonParser.parseString((String)json).getAsJsonObject().getAsJsonObject("mixinInfo");
            return (TaskMixinAnalyzer.ModTaskMixinMap)TaskMixinAnalyzer.ModTaskMixinMap.CODEC.apply(checkManager.getModsCodecO()).parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonData).resultOrPartial(error -> ModClazzChecker.LOGGER.error("read modmixinclazz error\uff1a{}, from file: {}", error, (Object)resource)).orElseThrow();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Boolean> readModTaskClazz(BaseClazzCheckManager<?, ?> checkManager) throws IOException {
        TaskClazzInfo taskClazzInfo = ClassAnalyzerManager.readModTaskClazzFromFile(checkManager);
        return VerifyExistence.verify(taskClazzInfo, checkManager);
    }

    public static Map<String, Boolean> readModTaskClazz(TaskClazzInfo taskClazzInfo, BaseClazzCheckManager<?, ?> checkManager) throws IOException {
        return VerifyExistence.verify(taskClazzInfo, checkManager);
    }

    private static String getEnumHolderValue(ModFileScanData.AnnotationData data, String name) {
        return ((ModAnnotation.EnumHolder)data.annotationData().get(name)).getValue();
    }

    private static List<ModAnnotation.EnumHolder> getEnumHolders(ModFileScanData.AnnotationData data, String name) {
        return (List)data.annotationData().get(name);
    }

    public static class ClassMap {
        private final Map<ITaskInfo<?>, Set<Class<?>>> map = new HashMap();
        private final Map<ITaskInfo<?>, Set<String>> mixinMap = new HashMap();

        private void addClazzes(ITaskInfo<?> taskInfo, Set<Class<?>> clazzes) {
            this.map.computeIfAbsent(taskInfo, taskInfo1 -> new HashSet()).addAll(clazzes);
        }

        private void addClazz(ITaskInfo<?> taskInfo, Class<?> clazz) {
            this.map.computeIfAbsent(taskInfo, taskInfo1 -> new HashSet()).add(clazz);
        }

        public List<Class<?>> getClazzs(ITaskInfo<?> taskInfo) {
            return Lists.newArrayList((Iterable)this.map.get(taskInfo));
        }

        public Map<ITaskInfo<?>, Set<Class<?>>> getMap() {
            return this.map;
        }

        public void addTaskMixin(ITaskInfo<?> taskInfo, String mixin) {
            this.mixinMap.computeIfAbsent(taskInfo, taskInfo1 -> new HashSet()).add(mixin);
        }

        public Map<ITaskInfo<?>, Set<String>> getMixinMap() {
            return this.mixinMap;
        }

        public static boolean isAllowed(String className, BaseClazzCheckManager<?, ?> checkManager) {
            for (String group : checkManager.getBlackGroups()) {
                if (className.startsWith(group)) {
                    return false;
                }
                if (!className.contains(group)) continue;
                return false;
            }
            return true;
        }
    }
}

