/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.kaleidoscopecookery.choppingboard;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.TickCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.task.cook.kaleidoscopecookery.choppingboard.ChoppingBoardRecSerializerManager;
import com.github.ysbbbbbb.kaleidoscopecookery.block.entity.ChoppingBoardBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.recipe.ChoppingBoardRecipe;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

@TaskClassAnalyzer(value=TaskInfo.KC_CHOPPING_BOARD)
public class ChoppingBoardRule
extends TickCookRule<ChoppingBoardBlockEntity, ChoppingBoardRecipe> {
    private static final ChoppingBoardRule INSTANCE = new ChoppingBoardRule();
    private boolean maidHand = false;
    private Item processItem = null;

    public static ChoppingBoardRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<ChoppingBoardBlockEntity> cookBeBase, MaidCookManager<ChoppingBoardRecipe> cm) {
        ChoppingBoardBlockEntity cuttingBoard = cookBeBase.getBe();
        if (!cuttingBoard.getCurrentCutStack().m_41619_() && this.hasBoardStackTool(cm.getMaid(), cuttingBoard)) {
            return true;
        }
        return cuttingBoard.getCurrentCutStack().m_41619_() && cm.hasMaidRecs(cookBeBase);
    }

    @Override
    public void cookMake(CookBeBase<ChoppingBoardBlockEntity> cookBeBase, MaidCookManager<ChoppingBoardRecipe> cm) {
        this.init(cookBeBase, cm);
        ItemStack storedItem = ((ChoppingBoardBlockEntity)this.be).getCurrentCutStack();
        if (!storedItem.m_41619_()) {
            ItemStack tool = this.getBoardStackTool(this.maid, (ChoppingBoardBlockEntity)this.be);
            if (tool.m_41619_()) {
                this.tickStop(cookBeBase, cm);
                return;
            }
            this.swapItem(InteractionHand.MAIN_HAND, tool, this.maid, (IItemHandler)this.maid.getAvailableInv(true));
            this.player.useByHand(InteractionHand.MAIN_HAND, this.pos);
            if (!storedItem.m_41619_()) {
                this.processItem = storedItem.m_41720_();
                ((ChoppingBoardBlockEntity)this.be).m_6596_();
                return;
            }
        }
        if (cm.hasMaidRecs(cookBeBase)) {
            MaidRec maidRec = cm.pollMaidRec(cookBeBase);
            ItemStack tool = maidRec.tool();
            ItemInventory itemInventory = cm.getItemInventory();
            ItemStack pollTool = itemInventory.getItemStacks(tool.m_41720_()).poll();
            if (pollTool == null) {
                return;
            }
            this.swapItem(InteractionHand.MAIN_HAND, pollTool, this.maid, (IItemHandler)this.maid.getAvailableInv(true));
            ItemDefinition processItem = maidRec.maidItems().get(0).item();
            ItemStack processItemPoll = itemInventory.getItemStacks(processItem).poll();
            if (processItemPoll == null) {
                return;
            }
            this.swapItem(InteractionHand.OFF_HAND, processItemPoll, this.maid, (IItemHandler)this.maid.getAvailableInv(true));
            this.processItem = processItem.item();
            cm.getItemInventory().markDirty();
        }
        ((ChoppingBoardBlockEntity)this.be).m_6596_();
    }

    @Override
    public boolean tickCan(CookBeBase<ChoppingBoardBlockEntity> cookBeBase, MaidCookManager<ChoppingBoardRecipe> cm) {
        return super.tickCan(cookBeBase, cm) && !this.maid.m_21205_().m_41619_() && this.processItem != null && (this.maid.m_21206_().m_150930_(this.processItem) || this.isProcessItem());
    }

    @Override
    public void tickCookMake(CookBeBase<ChoppingBoardBlockEntity> cookBeBase, MaidCookManager<ChoppingBoardRecipe> cm) {
        if (this.tick++ % 5 != 0) {
            return;
        }
        if (!((ChoppingBoardBlockEntity)this.be).getCurrentCutStack().m_41619_() || ((ChoppingBoardBlockEntity)this.be).getCurrentCutCount() < ((ChoppingBoardBlockEntity)this.be).getMaxCutCount()) {
            this.player.useByHand(InteractionHand.MAIN_HAND, this.pos);
        } else {
            ItemStack offhandItem = this.maid.m_21206_();
            if (offhandItem.m_150930_(this.processItem)) {
                this.player.useByHand(InteractionHand.OFF_HAND, this.pos);
            }
        }
    }

    private boolean hasBoardStackTool(EntityMaid maid, ChoppingBoardBlockEntity blockEntity) {
        return !this.getBoardStackTool(maid, blockEntity).m_41619_();
    }

    private ItemStack getBoardStackTool(EntityMaid maid, ChoppingBoardBlockEntity blockEntity) {
        Level level = maid.f_19853_;
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        Ingredient tool = ChoppingBoardRecSerializerManager.ChoppingRecipeInfoProvider.TOOL;
        return ItemsUtil.getStack((IItemHandler)maidInv, itemStack -> tool.test(itemStack));
    }

    private boolean isProcessItem() {
        return ((ChoppingBoardBlockEntity)this.be).getCurrentCutStack().m_150930_(this.processItem);
    }

    @Override
    public void tickStop(CookBeBase<ChoppingBoardBlockEntity> cookBeBase, MaidCookManager<ChoppingBoardRecipe> cm) {
        super.tickStop(cookBeBase, cm);
        this.processItem = null;
        this.maidHand = false;
    }

    @Override
    protected TickCookRule<ChoppingBoardBlockEntity, ChoppingBoardRecipe> create() {
        return new ChoppingBoardRule();
    }
}

