/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.craft.custom;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.util.IFailGuideUseActionContext;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IMaidStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageExtractableContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInteractContext;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class TakeItemAction
extends AbstractCraftActionContext
implements IFailGuideUseActionContext {
    public static final ResourceLocation TYPE = VResourceLocation.createMod("fail_take_all");
    protected IStorageContext storageContext;

    public TakeItemAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    public AbstractCraftActionContext.Result start() {
        ServerLevel level = (ServerLevel)this.maid.m_9236_();
        Target target = this.craftGuideStepData.getStorage();
        @Nullable Target validTarget = MaidStorage.getInstance().isValidTarget(level, (LivingEntity)this.maid, target);
        if (validTarget == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        @Nullable IMaidStorage storageType = MaidStorage.getInstance().getStorage(validTarget.getType());
        if (storageType == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        this.storageContext = storageType.onStartCollect(level, this.maid, validTarget);
        if (this.storageContext == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        this.storageContext.start(this.maid, level, validTarget);
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    public AbstractCraftActionContext.Result tick() {
        IStorageExtractableContext isec;
        if (this.allDone()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        MutableBoolean hasChange = new MutableBoolean(false);
        List allItems = this.craftGuideStepData.getOutput();
        Function<ItemStack, ItemStack> taker = itemStack -> {
            if (itemStack.m_41619_()) {
                return itemStack;
            }
            ItemStack takenItem = itemStack.m_255036_(itemStack.m_41613_());
            ItemStack itemStack1 = InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), (ItemStack)takenItem);
            takenItem.m_41774_(itemStack1.m_41613_());
            this.craftLayer.addCurrentStepPlacedCounts(this.idx, takenItem.m_41613_());
            if (takenItem.m_41613_() > 0) {
                hasChange.setTrue();
            }
            return itemStack.m_255036_(itemStack.m_41613_() - takenItem.m_41613_());
        };
        IStorageContext iStorageContext = this.storageContext;
        if (iStorageContext instanceof IStorageExtractableContext) {
            isec = (IStorageExtractableContext)iStorageContext;
            if (isec.hasTask()) {
                isec.tick(taker);
            } else {
                isec.setExtractByExisting(item -> allItems.stream().anyMatch(i -> ItemStackUtil.isSameInCrafting((ItemStack)i, (ItemStack)item)));
            }
        } else {
            iStorageContext = this.storageContext;
            if (iStorageContext instanceof IStorageInteractContext) {
                IStorageInteractContext isic = (IStorageInteractContext)iStorageContext;
                isic.tick(taker);
            }
        }
        if (this.storageContext.isDone()) {
            if (this.craftGuideStepData.isOptional()) {
                return AbstractCraftActionContext.Result.SUCCESS;
            }
            this.storageContext.reset();
            IStorageContext iStorageContext2 = this.storageContext;
            if (iStorageContext2 instanceof IStorageExtractableContext) {
                isec = (IStorageExtractableContext)iStorageContext2;
                isec.clearTask();
            }
            return hasChange.getValue() != false ? AbstractCraftActionContext.Result.CONTINUE_INTERRUPTABLE : AbstractCraftActionContext.Result.NOT_DONE_INTERRUPTABLE;
        }
        return hasChange.getValue() != false ? AbstractCraftActionContext.Result.CONTINUE : AbstractCraftActionContext.Result.NOT_DONE;
    }

    public void stop() {
        if (this.storageContext != null) {
            this.storageContext.finish();
        }
    }

    private boolean allDone() {
        if (this.craftGuideStepData == null) {
            return false;
        }
        List items = this.craftGuideStepData.getOutput();
        for (int i = 0; i < items.size(); ++i) {
            if (this.craftLayer.getCurrentStepCount(i) >= ((ItemStack)items.get(i)).m_41613_()) continue;
            return false;
        }
        return true;
    }
}

