/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.blockentity;

import io.github.tt432.kitchenkarrot.blockentity.MenuBlockEntity;
import io.github.tt432.kitchenkarrot.blockentity.sync.BoolSyncData;
import io.github.tt432.kitchenkarrot.blockentity.sync.IntSyncData;
import io.github.tt432.kitchenkarrot.blockentity.sync.StringSyncData;
import io.github.tt432.kitchenkarrot.blockentity.sync.SyncDataManager;
import io.github.tt432.kitchenkarrot.capability.KKItemStackHandler;
import io.github.tt432.kitchenkarrot.menu.AirCompressorMenu;
import io.github.tt432.kitchenkarrot.recipes.RecipeManager;
import io.github.tt432.kitchenkarrot.recipes.recipe.AirCompressorRecipe;
import io.github.tt432.kitchenkarrot.registries.ModBlockEntities;
import io.github.tt432.kitchenkarrot.tag.ModItemTags;
import io.github.tt432.kitchenkarrot.util.ItemHandlerUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AirCompressorBlockEntity
extends MenuBlockEntity {
    static final int MAX_ENERGY = 120;
    ItemStackHandler input1 = new KKItemStackHandler(this, 5){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            if (!this.isItemValid(slot, stack)) {
                return;
            }
            super.setStackInSlot(slot, stack);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot != 4 || stack.m_204117_(ModItemTags.CONTAINER_ITEM);
        }
    };
    ItemStackHandler input2 = new KKItemStackHandler(this, 1){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            if (!this.isItemValid(slot, stack)) {
                return;
            }
            super.setStackInSlot(slot, stack);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_150930_(Items.f_42451_);
        }
    };
    ItemStackHandler output = new KKItemStackHandler(this, 1);
    private IntSyncData progress;
    private IntSyncData maxProgress;
    private IntSyncData energy;
    private StringSyncData recipeId;
    private AirCompressorRecipe recipe;
    private BoolSyncData started;

    public AirCompressorBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.AIR_COMPRESSOR.get(), pWorldPosition, pBlockState);
    }

    @Override
    protected void syncDataInit(SyncDataManager manager) {
        this.recipeId = new StringSyncData("recipe", "", true);
        manager.add(this.recipeId);
        this.progress = new IntSyncData("progress", 0, true);
        manager.add(this.progress);
        this.maxProgress = new IntSyncData("max_progress", 1, true);
        manager.add(this.maxProgress);
        this.energy = new IntSyncData("energy", 0, true);
        manager.add(this.energy);
        this.started = new BoolSyncData("started", false, true);
        manager.add(this.started);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.canCharge()) {
            this.charge();
        }
        if (!this.f_58857_.f_46443_) {
            if (this.isStarted()) {
                if (this.isRecipeSame()) {
                    if (this.progress.plus(1, this.getMaxProgress()) == this.getMaxProgress()) {
                        this.finish();
                    }
                } else {
                    this.stop();
                }
            } else {
                AirCompressorRecipe recipePredicate = this.getRecipeFromItems();
                if (this.hasEnergy() && recipePredicate != null && this.isSlotAvailable(recipePredicate)) {
                    this.start(recipePredicate);
                }
            }
        }
    }

    public AirCompressorRecipe getRecipe() {
        return this.recipe == null && !this.recipeId.isEmpty() ? (this.recipe = (AirCompressorRecipe)this.f_58857_.m_7465_().m_44043_(new ResourceLocation((String)this.recipeId.get())).get()) : this.recipe;
    }

    private AirCompressorRecipe getRecipeFromItems() {
        List<ItemStack> items = ItemHandlerUtils.toList(new IItemHandler[]{this.input1});
        ItemStack container = items.remove(4);
        return RecipeManager.getAirCompressorRecipe(this.f_58857_).stream().filter(r -> r.matches(items) && r.testContainer(container)).findFirst().orElse(null);
    }

    private boolean isSlotAvailable(AirCompressorRecipe recipe) {
        ItemStack resultStack = this.output.getStackInSlot(0);
        return resultStack.m_41619_() || resultStack.m_150930_(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_()) && resultStack.m_41613_() < resultStack.m_41741_();
    }

    private void finish() {
        for (int i = 0; i < this.input1.getSlots(); ++i) {
            ItemStack remaining = this.input1.getStackInSlot(i).getCraftingRemainingItem();
            if (remaining != ItemStack.f_41583_) {
                this.popRemainingItem(remaining);
            }
            this.input1.extractItem(i, 1, false);
        }
        this.energy.reduce(10, 0);
        this.output.insertItem(0, this.getRecipe().m_8043_((RegistryAccess)RegistryAccess.f_243945_), false);
        this.stop();
    }

    private void popRemainingItem(ItemStack remaining) {
        BlockPos pos = this.m_58899_();
        RandomSource random = this.f_58857_.m_213780_();
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, remaining, (double)(random.m_188501_() * 2.0f - 1.0f), (double)random.m_188501_(), (double)(random.m_188501_() * 2.0f - 1.0f)));
    }

    private boolean isRecipeSame() {
        AirCompressorRecipe recipe = this.getRecipe();
        List<ItemStack> items = ItemHandlerUtils.toList(new IItemHandler[]{this.input1});
        ItemStack container = items.remove(4);
        return recipe != null && recipe.matches(items) && recipe.testContainer(container);
    }

    private boolean isStarted() {
        return (Boolean)this.started.get();
    }

    protected void start(AirCompressorRecipe pRecipe) {
        this.setRecipe(pRecipe);
        this.maxProgress.set(this.recipe.getCraftingTime());
        this.started.set(true);
    }

    protected void setRecipe(AirCompressorRecipe recipe) {
        this.recipe = recipe;
        if (recipe != null) {
            this.recipeId.set(recipe.m_6423_().toString());
        } else {
            this.recipeId.set("");
        }
    }

    protected void charge() {
        this.input2.extractItem(0, 1, false);
        this.energy.set(120);
        this.m_6596_();
    }

    protected boolean hasEnergy() {
        return (Integer)this.energy.get() >= 10;
    }

    protected boolean canCharge() {
        return this.input2.getStackInSlot(0).m_150930_(Items.f_42451_) && this.getEnergy() < 10;
    }

    public int getEnergy() {
        return (Integer)this.energy.get();
    }

    public int getAtomicEnergy() {
        return this.getEnergy() / 10;
    }

    protected void stop() {
        this.recipe = null;
        this.recipeId.set("");
        this.progress.set(0);
        this.maxProgress.set(1);
        this.started.set(false);
    }

    @Override
    public List<ItemStack> drops() {
        return ItemHandlerUtils.toList(new IItemHandler[]{this.input1, this.input2, this.output});
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return side == null ? LazyOptional.empty() : ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> this.output;
            case Direction.UP -> this.input1;
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> this.input2;
        }));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new AirCompressorMenu(pContainerId, pInventory, this);
    }

    public int getProgress() {
        return (Integer)this.progress.get();
    }

    public int getMaxProgress() {
        return (Integer)this.maxProgress.get();
    }

    public ItemStackHandler getInput1() {
        return this.input1;
    }

    public ItemStackHandler getInput2() {
        return this.input2;
    }

    public ItemStackHandler getOutput() {
        return this.output;
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        CompoundTag input1 = this.getInput1().serializeNBT();
        CompoundTag input2 = this.getInput2().serializeNBT();
        CompoundTag output = this.getOutput().serializeNBT();
        pTag.m_128365_("input1", (Tag)input1);
        pTag.m_128365_("input2", (Tag)input2);
        pTag.m_128365_("output", (Tag)output);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (!this.isSyncTag(pTag)) {
            this.input1.deserializeNBT(pTag.m_128469_("input1"));
            this.input2.deserializeNBT(pTag.m_128469_("input2"));
            this.output.deserializeNBT(pTag.m_128469_("output"));
        }
    }
}

