/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.client.plate;

import io.github.tt432.kitchenkarrot.block.PlateHolderMap;
import io.github.tt432.kitchenkarrot.client.plate.PlateList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;

public class PlateModelRegistry {
    public static final Map<ResourceLocation, ResourceLocation> MODEL_MAP = new HashMap<ResourceLocation, ResourceLocation>();
    public static ResourceLocation DEFAULT_NAME = new ResourceLocation("kitchenkarrot", "plate");

    static ResourceLocation from(ModelResourceLocation modelResourceLocation) {
        return new ResourceLocation(modelResourceLocation.m_135827_(), modelResourceLocation.m_135815_().split("plates/")[1]);
    }

    public static ResourceLocation to(ResourceLocation resourceLocation) {
        return new ResourceLocation(resourceLocation.m_135827_(), "plates/" + resourceLocation.m_135815_());
    }

    public static void register(ModelEvent.RegisterAdditional e) {
        PlateList.INSTANCE.plates.clear();
        HashSet plates = new HashSet();
        PlateHolderMap.plateHolder.forEach((key, value) -> {
            for (int i = 1; i <= value; ++i) {
                plates.add(new ResourceLocation("kitchenkarrot", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(key)).m_135815_()) + "_" + i);
            }
        });
        PlateList.INSTANCE.plates.addAll(plates);
        e.register(PlateModelRegistry.to(DEFAULT_NAME));
        for (String info : PlateList.INSTANCE.plates) {
            e.register(PlateModelRegistry.to(new ResourceLocation(info)));
        }
    }

    static BlockModel getModel(String info) {
        String path;
        ResourceLocation name;
        String namespace;
        ResourceLocation modelName;
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        if (manager.m_213713_(modelName = new ResourceLocation(namespace = (name = new ResourceLocation(info)).m_135827_(), "models/plates/" + (path = name.m_135815_()) + ".json")).isPresent()) {
            try {
                Optional resource = manager.m_213713_(modelName);
                String json = IOUtils.toString((InputStream)((Resource)resource.get()).m_215507_(), (Charset)StandardCharsets.UTF_8);
                return BlockModel.m_111463_((String)json);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

