/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.glm;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ReplaceLootModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ItemStack.f_41582_.fieldOf("item").forGetter(m -> m.itemStack), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(m -> m.weight), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(m -> m.count))).apply((Applicative)inst, ReplaceLootModifier::new)));
    private final ItemStack itemStack;
    private final int weight;
    private final int count;

    public ReplaceLootModifier(LootItemCondition[] conditionsIn, ItemStack itemStack, int weight, int count) {
        super(conditionsIn);
        this.itemStack = itemStack;
        this.weight = weight;
        this.count = count;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_230907_().m_188503_(900) < this.weight) {
            generatedLoot.clear();
            ItemStack copy = this.itemStack.m_41777_();
            copy.m_41764_(context.m_230907_().m_188503_(this.count) + 1);
            generatedLoot.add((Object)copy);
        }
        return generatedLoot;
    }

    @NotNull
    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

