/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.item;

import io.github.tt432.kitchenkarrot.config.ModCommonConfigs;
import io.github.tt432.kitchenkarrot.recipes.object.EffectStack;
import io.github.tt432.kitchenkarrot.recipes.recipe.CocktailRecipe;
import io.github.tt432.kitchenkarrot.registries.ModItems;
import io.github.tt432.kitchenkarrot.registries.RecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
public class CocktailItem
extends Item {
    public static final ResourceLocation UNKNOWN_COCKTAIL = new ResourceLocation("kitchenkarrot", "unknown");

    public CocktailItem() {
        super(ModItems.defaultProperties().m_41489_(new FoodProperties.Builder().m_38765_().m_38767_()));
    }

    public static ItemStack unknownCocktail() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.COCKTAIL.get());
        CocktailItem.setCocktail(stack, UNKNOWN_COCKTAIL);
        return stack;
    }

    public ItemStack m_5922_(ItemStack stack, Level pLevel, LivingEntity livingEntity) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ResourceLocation cocktail = CocktailItem.getCocktail(stack);
            if (cocktail != null) {
                CocktailRecipe recipe = CocktailItem.get(pLevel, cocktail);
                if (recipe != null) {
                    player.m_36324_().m_38707_(recipe.content.hunger, (float)recipe.content.saturation);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    for (EffectStack effectStack : recipe.content.getEffect()) {
                        player.m_7292_(effectStack.get());
                    }
                } else if (cocktail.equals((Object)UNKNOWN_COCKTAIL)) {
                    player.m_7292_(new MobEffectInstance(this.getUnknownCocktailEffect(pLevel), 100, 0));
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                }
            }
        }
        return stack;
    }

    private MobEffect getUnknownCocktailEffect(Level level) {
        List list = (List)ModCommonConfigs.UNKNOWN_COCKTAIL_EFFECTS_BLACKLIST.get();
        ArrayList<MobEffect> effects = new ArrayList<MobEffect>();
        for (String s : list) {
            try {
                effects.add((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(s)));
            }
            catch (Exception exception) {}
        }
        if (!((Boolean)ModCommonConfigs.WHITELIST_MODE.get()).booleanValue()) {
            ArrayList values = new ArrayList(ForgeRegistries.MOB_EFFECTS.getValues().stream().toList());
            values.removeAll(effects);
            return (MobEffect)values.get(level.m_213780_().m_188503_(values.size()));
        }
        return (MobEffect)effects.get(level.m_213780_().m_188503_(effects.size()));
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public String m_5671_(ItemStack stack) {
        ResourceLocation name = CocktailItem.getCocktail(stack);
        if (name != null) {
            return name.toString().replace(":", ".");
        }
        return super.m_5671_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        ResourceLocation name = CocktailItem.getCocktail(stack);
        if (name != null && level != null) {
            tooltip.add((Component)Component.m_237115_((String)(name.toString().replace(":", ".") + ".tooltip")));
            CocktailRecipe recipe = CocktailItem.get(level, Objects.requireNonNull(CocktailItem.getCocktail(stack)));
            if (recipe != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.cocktail.author", (Object[])new Object[]{recipe.author}));
                CocktailRecipe cocktailRecipe = CocktailItem.get(level, name);
                if (cocktailRecipe != null) {
                    List<MobEffectInstance> list = cocktailRecipe.getContent().getEffect().stream().map(EffectStack::get).toList();
                    PotionUtils.m_257410_(list, tooltip, (float)1.0f);
                }
            }
        }
    }

    @Nullable
    public static ResourceLocation getCocktail(ItemStack itemStack) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("cocktail")) {
            return new ResourceLocation(itemStack.m_41783_().m_128461_("cocktail"));
        }
        return null;
    }

    public static void setCocktail(ItemStack itemStack, ResourceLocation name) {
        itemStack.m_41784_().m_128359_("cocktail", name.toString());
    }

    @Nullable
    public static CocktailRecipe get(Level level, ResourceLocation resourceLocation) {
        Optional result = level.m_7465_().m_44043_(resourceLocation);
        if (result.isPresent() && ((Recipe)result.get()).m_6671_() == RecipeTypes.COCKTAIL.get()) {
            return (CocktailRecipe)result.get();
        }
        return null;
    }
}

