/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.item;

import io.github.tt432.kitchenkarrot.item.ModFood;
import io.github.tt432.kitchenkarrot.registries.ModBlocks;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class EmptyPlateItem
extends ModFood {
    public EmptyPlateItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult interactionResult = this.place(new BlockPlaceContext(context));
        if (!interactionResult.m_19077_() && this.m_41472_() && context.m_43723_() != null) {
            InteractionResult interactionResult1 = this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
            return interactionResult1 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionResult1;
        }
        return interactionResult;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockPlaceContext = this.updatePlacementContext(context);
        if (blockPlaceContext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = this.getPlacementState(blockPlaceContext);
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockPlaceContext, blockState)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        Player player = blockPlaceContext.m_43723_();
        ItemStack itemStack = blockPlaceContext.m_43722_();
        BlockState blockState1 = level.m_8055_(blockPos);
        if (blockState1.m_60713_(blockState.m_60734_())) {
            blockState1 = this.updateBlockStateFromTag(blockPos, level, itemStack, blockState1);
            this.updateCustomBlockEntityTag(blockPos, level, player, itemStack);
            blockState1.m_60734_().m_6402_(level, blockPos, blockState1, (LivingEntity)player, itemStack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockPos, itemStack);
            }
        }
        level.m_142346_((Entity)player, GameEvent.f_157797_, blockPos);
        SoundType soundType = blockState1.getSoundType((LevelReader)level, blockPos, (Entity)context.m_43723_());
        float volume = (soundType.m_56773_() + 1.0f) / 2.0f;
        float pitch = soundType.m_56774_() * 0.8f;
        level.m_5594_(player, blockPos, SoundEvents.f_12447_, SoundSource.BLOCKS, volume, pitch);
        if (player == null || !player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    protected void updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack) {
        EmptyPlateItem.updateCustomBlockEntityTag(level, player, pos, stack);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState blockstate = this.getBlock().m_5573_(context);
        return blockstate != null && this.canPlace(context, blockstate) ? blockstate : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        BlockState blockState = state;
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null) {
            CompoundTag compoundTag1 = compoundTag.m_128469_("BlockStateTag");
            StateDefinition stateDefinition = state.m_60734_().m_49965_();
            for (String s : compoundTag1.m_128431_()) {
                Property property = stateDefinition.m_61081_(s);
                if (property == null) continue;
                String s1 = Objects.requireNonNull(compoundTag1.m_128423_(s)).m_7916_();
                blockState = EmptyPlateItem.updateState(blockState, property, s1);
            }
        }
        if (blockState != state) {
            level.m_7731_(pos, blockState, 2);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> property, String valueIdentifier) {
        return property.m_6215_(valueIdentifier).map(t -> (BlockState)state.m_61124_(property, t)).orElse(state);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.m_43723_();
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) && context.m_43725_().m_45752_(state, context.m_8083_(), collisioncontext);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }

    public static void updateCustomBlockEntityTag(Level level, @Nullable Player player, BlockPos pos, ItemStack stack) {
        BlockEntity blockentity;
        CompoundTag compoundTag;
        MinecraftServer server = level.m_7654_();
        if (server != null && (compoundTag = EmptyPlateItem.getBlockEntityData(stack)) != null && (blockentity = level.m_7702_(pos)) != null) {
            if (!(level.f_46443_ || !blockentity.m_6326_() || player != null && player.m_36337_())) {
                return;
            }
            CompoundTag compoundTag1 = blockentity.m_187482_();
            CompoundTag compoundTag2 = compoundTag1.m_6426_();
            compoundTag1.m_128391_(compoundTag);
            if (!compoundTag1.equals((Object)compoundTag2)) {
                blockentity.m_142466_(compoundTag1);
                blockentity.m_6596_();
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        this.getBlock().m_5871_(stack, (BlockGetter)level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"info.kitchenkarrot.text1"));
        tooltip.add((Component)Component.m_237115_((String)"info.kitchenkarrot.text2"));
        tooltip.add((Component)Component.m_237115_((String)"info.kitchenkarrot.text3"));
    }

    public Block getBlock() {
        return (Block)ModBlocks.PLATE.get();
    }

    @Nullable
    public static CompoundTag getBlockEntityData(ItemStack itemStack) {
        return itemStack.m_41737_("BlockEntityTag");
    }
}

