/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.recipes.recipe;

import com.google.gson.annotations.Expose;
import io.github.tt432.kitchenkarrot.block.PlateHolderMap;
import io.github.tt432.kitchenkarrot.recipes.base.BaseRecipe;
import io.github.tt432.kitchenkarrot.registries.RecipeSerializers;
import io.github.tt432.kitchenkarrot.registries.RecipeTypes;
import io.github.tt432.kitchenkarrot.tag.ModItemTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class PlateRecipe
extends BaseRecipe<PlateRecipe> {
    @Expose
    Input input;
    @Expose
    @NotNull
    Output result = new Output();
    @Expose
    @Nullable
    Ingredient tool;

    public Item getInput() {
        return this.input.getItem();
    }

    public int getResultCount() {
        return PlateHolderMap.plateHolder.get(this.result.getItem());
    }

    public ItemStack getResultStack() {
        return new ItemStack((ItemLike)this.result.getItem(), this.getResultCount());
    }

    public Ingredient getTool() {
        return this.tool == null || this.tool.m_43947_() ? this.result.defaultTool : this.tool;
    }

    public boolean canCut(ItemStack tool, ItemStack input) {
        return this.getTool().test(tool) && this.getInput() == input.m_41720_();
    }

    @Override
    public boolean matches(List<ItemStack> inputs) {
        return inputs.get(0).m_150930_(this.getInput());
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.result.item != null ? new ItemStack((ItemLike)this.result.getItem()) : ItemStack.f_41583_;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.PLATE.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypes.PLATE.get();
    }

    static class Output {
        @Expose
        String item;
        Ingredient defaultTool = Ingredient.m_204132_(ModItemTags.KNIFE_ITEM);
        Item cache;

        Output() {
        }

        Item getItem() {
            return this.cache == null ? (this.cache = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.item))) : this.cache;
        }
    }

    static class Input {
        @Expose
        String item;
        Item cache;

        Input() {
        }

        Item getItem() {
            return this.cache == null ? (this.cache = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.item))) : this.cache;
        }
    }
}

