/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.craft.special;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.RecipeFinderUtil;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

@TaskClassAnalyzer(value=TaskInfo.MSM_CORE)
public class StoneCutterRecipeAction
extends AbstractCraftActionContext {
    public static final ResourceLocation TYPE = VResourceLocation.createMod("stone_cutter");
    protected ResourceLocation recipeType;

    public StoneCutterRecipeAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    public AbstractCraftActionContext.Result start() {
        if (this.craftGuideStepData.getStorage() == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        CompoundTag extraData = this.craftGuideStepData.getExtraData();
        this.recipeType = Cutter.from(extraData).recType();
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    public AbstractCraftActionContext.Result tick() {
        ItemStack tmpResult;
        ItemStack result;
        Optional<Recipe> first;
        Level level = this.maid.m_9236_();
        CombinedInvWrapper inv = this.maid.getAvailableInv(false);
        ItemStack input = (ItemStack)this.craftGuideStepData.getInput().get(0);
        ItemStack output = (ItemStack)this.craftGuideStepData.getOutput().get(0);
        ItemStack t1 = InvUtil.tryExtractForCrafting((IItemHandler)inv, (ItemStack)input);
        if (ItemStackUtil.isSameInCrafting((ItemStack)t1, (ItemStack)input) && (first = RecipeFinderUtil.getCutterRecipe(level, this.recipeType, t1).stream().filter(recipe -> ItemStackUtil.isSameInCrafting((ItemStack)recipe.m_8043_(level.m_9598_()), (ItemStack)output)).findFirst()).isPresent() && ItemStackUtil.isSameInCrafting((ItemStack)(result = (tmpResult = first.get().m_8043_(level.m_9598_())).m_255036_(tmpResult.m_41613_() * input.m_41613_())), (ItemStack)output)) {
            this.craftLayer.addCurrentStepPlacedCounts(0, result.m_41613_());
            int maxCanPlace = InvUtil.maxCanPlace((IItemHandler)inv, (ItemStack)result);
            if (maxCanPlace >= result.m_41613_()) {
                InvUtil.tryPlace((IItemHandler)inv, (ItemStack)result);
                level.m_5594_(null, this.craftGuideStepData.storage.pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return AbstractCraftActionContext.Result.SUCCESS;
            }
        }
        InvUtil.tryPlace((IItemHandler)inv, (ItemStack)t1);
        return AbstractCraftActionContext.Result.FAIL;
    }

    public void stop() {
    }

    public record Cutter(ResourceLocation recType) {
        public static final Codec<Cutter> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ResourceLocation.f_135803_.fieldOf("recType").forGetter(Cutter::recType)).apply((Applicative)ins, Cutter::new));

        public CompoundTag toCompoundTag() {
            return CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().map(tag -> (CompoundTag)tag).orElseGet(CompoundTag::new);
        }

        public static CompoundTag toCompoundTag(ResourceLocation recType) {
            return new Cutter(recType).toCompoundTag();
        }

        public static Cutter from(CompoundTag compoundTag) {
            return (Cutter)CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag).result().orElseThrow();
        }
    }
}

