/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.ModClazzChecker;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ITaskInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.TaskMixinAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.ClassAnalyzerManager;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.McMethodOrFieldVerify;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.TaskClazzInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager.BaseClazzCheckManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.asm.mixin.Mixin;

public class ClassAnalyzerTool {
    public static void analyzerAndGenerateFile(Path rootOutputFolder, ClassAnalyzerManager.ClassMap classMap, BaseClazzCheckManager<?, ?> checkManager) throws Exception {
        HashMap<ITaskInfo, ClazzInfoRuntime> runtimeMap = new HashMap<ITaskInfo, ClazzInfoRuntime>();
        for (Map.Entry<ITaskInfo<?>, Set<Class<?>>> entry : classMap.getMap().entrySet()) {
            Set<Class<?>> classes = entry.getValue();
            ClazzInfoRuntime infoRuntime = ClassAnalyzerTool.analyze(classes, checkManager);
            ITaskInfo<?> taskInfo = entry.getKey();
            runtimeMap.put(taskInfo, infoRuntime);
        }
        for (Map.Entry<ITaskInfo<?>, Set<Object>> entry : classMap.getMixinMap().entrySet()) {
            ITaskInfo<?> key = entry.getKey();
            Set<Object> vals = entry.getValue();
            ClazzInfoRuntime clazzInfoRuntime = runtimeMap.computeIfAbsent(key, k -> new ClazzInfoRuntime());
            for (String string : vals) {
                ClassAnalyzerTool.analyzerFromMixinTask(checkManager, string, clazzInfoRuntime);
            }
        }
        HashMap<String, TaskClazzInfo.ClazzTaskInfo> map = new HashMap<String, TaskClazzInfo.ClazzTaskInfo>();
        runtimeMap.forEach((k, v) -> map.put(k.getUidStr(), TaskClazzInfo.ClazzTaskInfo.create(k, v.toClazzInfo())));
        TaskMixinAnalyzer.ModTaskMixinMap modTaskMixinMap = TaskMixinAnalyzer.collectModTaskClazz(checkManager);
        TaskClazzInfo taskClazzInfo = new TaskClazzInfo(map, modTaskMixinMap);
        TaskClazzInfo.CODEC.apply(checkManager.getModsCodecO()).encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)taskClazzInfo).resultOrPartial(error -> ModClazzChecker.LOGGER.error("Build failed\uff1a{}", error)).ifPresent(data -> {
            File file = new File(rootOutputFolder.toString().replace("generated", "main") + "\\" + checkManager.getFileName());
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(gson.toJson(data));
                fileWriter.close();
                ModClazzChecker.LOGGER.info("Build succeed\uff1a{}", (Object)file.getPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void analyzerFromMixinTask(final BaseClazzCheckManager<?, ?> checkManager, final String mixinClazzName, final ClazzInfoRuntime clazzInfoRuntime) throws Exception {
        final String targetMixinSource = ClassAnalyzerTool.getTargetMixinSource(mixinClazzName);
        ClassReader cr = new ClassReader(mixinClazzName);
        cr.accept(new ClassVisitor(589824){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitor(589824){

                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        Set<String> classesFromDescriptor = ClassAnalyzerTool.parseClassesFromDescriptor(descriptor);
                        for (String descriptorClass : classesFromDescriptor) {
                            if (!ClassAnalyzerManager.ClassMap.isAllowed(descriptorClass, checkManager)) continue;
                            clazzInfoRuntime.addClazz(descriptorClass);
                        }
                        String replace = owner.replace('/', '.');
                        String className = replace.contains(mixinClazzName) ? targetMixinSource : replace;
                        String methodName = className + "#" + name + descriptor;
                        boolean isMcMethod = false;
                        try {
                            isMcMethod = McMethodOrFieldVerify.isMcMethod(className, name + descriptor, checkManager);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        if (isMcMethod) {
                            return;
                        }
                        if (ClassAnalyzerManager.ClassMap.isAllowed(className, checkManager)) {
                            clazzInfoRuntime.addClazz(className);
                            clazzInfoRuntime.addMethod(methodName);
                        }
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                        String className;
                        String replace = owner.replace('/', '.');
                        String string = className = replace.contains(mixinClazzName) ? targetMixinSource : replace;
                        if (ClassAnalyzerManager.ClassMap.isAllowed(className, checkManager)) {
                            String fieldName = className + "#" + name;
                            boolean isMcFiled = false;
                            try {
                                isMcFiled = McMethodOrFieldVerify.isMcField(className, fieldName, checkManager);
                            }
                            catch (ClassNotFoundException e) {
                                throw new RuntimeException(e);
                            }
                            if (isMcFiled) {
                                return;
                            }
                            clazzInfoRuntime.addClazz(className);
                            clazzInfoRuntime.addField(fieldName);
                        }
                    }
                };
            }
        }, 0);
    }

    private static String getTargetMixinSource(String mixinClazzName) {
        String targetMixinSource = "";
        Type mixinType = Type.getType(Mixin.class);
        block0: for (ModFileScanData scanData : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                List targets;
                Iterator iterator;
                String mixinClazz;
                Type annotationedType = data.annotationType();
                if (!annotationedType.equals((Object)mixinType) || !(mixinClazz = data.memberName()).equals(mixinClazzName)) continue;
                if (data.annotationData().get("value") != null) {
                    String string = ((List)data.annotationData().get("value")).get(0).toString();
                    string = string.substring(1, string.length() - 1);
                    targetMixinSource = string.replace("/", ".");
                    break block0;
                }
                if (data.annotationData().get("targets") == null || !(iterator = (targets = (List)data.annotationData().get("targets")).iterator()).hasNext()) continue;
                String target = (String)iterator.next();
                targetMixinSource = target.replace("/", ".");
                break block0;
            }
        }
        if (targetMixinSource.isEmpty()) {
            throw new RuntimeException("can not find" + mixinClazzName + " target source");
        }
        return targetMixinSource;
    }

    private static ClazzInfoRuntime analyze(Set<Class<?>> targetClasses, BaseClazzCheckManager<?, ?> checkManager) throws Exception {
        ClazzInfoRuntime clazzInfoRuntime = new ClazzInfoRuntime();
        for (Class<?> clazz : targetClasses) {
            ClassAnalyzerTool.analyzeSingleClass(clazz, clazzInfoRuntime, checkManager);
            for (Class<?> superAndInterfaceClazz : ClassAnalyzerTool.getSuperAndInterfaceClazzs(clazz, checkManager)) {
                ClassAnalyzerTool.analyzeSingleClass(superAndInterfaceClazz, clazzInfoRuntime, checkManager);
            }
        }
        return clazzInfoRuntime;
    }

    private static Set<Class<?>> getSuperAndInterfaceClazzs(Class<?> clazz, BaseClazzCheckManager<?, ?> checkManager) {
        Class<?>[] interfaceClazzs;
        String modPackage = checkManager.getModPackage();
        HashSet superClazzs = new HashSet();
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && superClazz.getName().startsWith(modPackage)) {
            superClazzs.add(superClazz);
            superClazzs.addAll(ClassAnalyzerTool.getSuperAndInterfaceClazzs(superClazz, checkManager));
        }
        for (Class<?> interfaceClazz : interfaceClazzs = clazz.getInterfaces()) {
            if (!interfaceClazz.getName().startsWith(modPackage)) continue;
            superClazzs.add(interfaceClazz);
            superClazzs.addAll(ClassAnalyzerTool.getSuperAndInterfaceClazzs(interfaceClazz, checkManager));
        }
        return superClazzs;
    }

    private static void analyzeSingleClass(Class<?> clazz, final ClazzInfoRuntime clazzInfoRuntime, final BaseClazzCheckManager<?, ?> checkManager) throws IOException, ClassNotFoundException {
        for (Field field : clazz.getDeclaredFields()) {
            if (!ClassAnalyzerManager.ClassMap.isAllowed(field.getDeclaringClass().getName(), checkManager)) continue;
            String fieldName = field.getDeclaringClass().getName() + "#" + field.getName();
            clazzInfoRuntime.addField(fieldName);
        }
        ClassReader cr = new ClassReader(clazz.getName());
        cr.accept(new ClassVisitor(589824){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitor(589824){

                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        Set<String> classesFromDescriptor = ClassAnalyzerTool.parseClassesFromDescriptor(descriptor);
                        for (String descriptorClass : classesFromDescriptor) {
                            if (!ClassAnalyzerManager.ClassMap.isAllowed(descriptorClass, checkManager)) continue;
                            clazzInfoRuntime.addClazz(descriptorClass);
                        }
                        String className = owner.replace('/', '.');
                        String methodName = className + "#" + name + descriptor;
                        boolean isMcMethod = false;
                        try {
                            isMcMethod = McMethodOrFieldVerify.isMcMethod(className, name + descriptor, checkManager);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        if (isMcMethod) {
                            return;
                        }
                        if (ClassAnalyzerManager.ClassMap.isAllowed(className, checkManager)) {
                            clazzInfoRuntime.addClazz(className);
                            clazzInfoRuntime.addMethod(methodName);
                        }
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                        String className = owner.replace('/', '.');
                        if (ClassAnalyzerManager.ClassMap.isAllowed(className, checkManager)) {
                            String fieldName = className + "#" + name;
                            boolean isMcFiled = false;
                            try {
                                isMcFiled = McMethodOrFieldVerify.isMcField(className, fieldName, checkManager);
                            }
                            catch (ClassNotFoundException e) {
                                throw new RuntimeException(e);
                            }
                            if (isMcFiled) {
                                return;
                            }
                            clazzInfoRuntime.addClazz(className);
                            clazzInfoRuntime.addField(fieldName);
                        }
                    }
                };
            }
        }, 0);
        for (Class<?> innerClass : ClassAnalyzerTool.findAllInnerClasses(clazz)) {
            ClassAnalyzerTool.analyzeSingleClass(innerClass, clazzInfoRuntime, checkManager);
        }
    }

    private static Set<Class<?>> findAllInnerClasses(Class<?> clazz) throws IOException, ClassNotFoundException {
        LinkedHashSet innerClasses = new LinkedHashSet();
        for (Class<?> declaredClass : clazz.getDeclaredClasses()) {
            innerClasses.add(declaredClass);
            innerClasses.addAll(ClassAnalyzerTool.findAllInnerClasses(declaredClass));
        }
        String className = clazz.getName().replace('.', '/');
        URL resource = clazz.getClassLoader().getResource(className + ".class");
        if (resource != null && resource.toString().startsWith("jar:")) {
            String jarPath = resource.toString().substring(4, resource.toString().indexOf("!"));
            try (JarFile jarFile = new JarFile(jarPath.substring(5));){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(className) || !entryName.contains("$") || !entryName.endsWith(".class")) continue;
                    String innerClassName = entryName.replace('/', '.').replace(".class", "");
                    innerClasses.add(Class.forName(innerClassName));
                }
            }
        }
        return innerClasses;
    }

    private static Set<String> parseClassesFromDescriptor(String descriptor) {
        HashSet<String> classes = new HashSet<String>();
        if (descriptor.startsWith("(")) {
            int paramEnd = descriptor.indexOf(41);
            String paramPart = descriptor.substring(1, paramEnd);
            String returnPart = descriptor.substring(paramEnd + 1);
            ClassAnalyzerTool.parseTypes(paramPart, classes);
            ClassAnalyzerTool.parseTypes(returnPart, classes);
        } else {
            ClassAnalyzerTool.parseTypes(descriptor, classes);
        }
        return classes;
    }

    private static void parseTypes(String typeDescriptor, Set<String> classes) {
        int index = 0;
        while (index < typeDescriptor.length()) {
            char c = typeDescriptor.charAt(index);
            if (c == 'L') {
                int end = typeDescriptor.indexOf(59, index);
                if (end != -1) {
                    String className = typeDescriptor.substring(index + 1, end).replace('/', '.');
                    classes.add(className);
                    index = end + 1;
                    continue;
                }
                ++index;
                continue;
            }
            if (c == '[') {
                ++index;
                continue;
            }
            ++index;
        }
    }

    private record ClazzInfoRuntime(Set<String> classes, Set<String> methods, Set<String> fields) {
        public ClazzInfoRuntime() {
            this(new HashSet<String>(), new HashSet<String>(), new HashSet<String>());
        }

        public void addClazz(String clazzName) {
            this.classes.add(clazzName);
        }

        public void addMethod(String methodName) {
            this.methods.add(methodName);
        }

        public void addField(String fieldName) {
            this.fields.add(fieldName);
        }

        public TaskClazzInfo.ClazzInfo toClazzInfo() {
            List<String> clazzsSort = this.classes.stream().sorted().toList();
            List<String> methodsSort = this.methods.stream().sorted().toList();
            List<String> fieldsSort = this.fields.stream().sorted().toList();
            return new TaskClazzInfo.ClazzInfo(clazzsSort, methodsSort, fieldsSort);
        }
    }
}

